/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetItemRequestMarshaller
implements Marshaller<Request<GetItemRequest>, GetItemRequest> {
    @Override
    public Request<GetItemRequest> marshall(GetItemRequest getItemRequest) {
        if (getItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetItemRequest> request = new DefaultRequest<GetItemRequest>(getItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.GetItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            List<String> attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (getItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(getItemRequest.getTableName());
            }
            if (getItemRequest.getKey() != null) {
                jsonWriter.key("Key");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> keyListValue : getItemRequest.getKey().entrySet()) {
                    List<ByteBuffer> bSList;
                    List<String> nSList;
                    List<String> sSList;
                    if (keyListValue.getValue() == null) continue;
                    jsonWriter.key(keyListValue.getKey());
                    jsonWriter.object();
                    if (keyListValue.getValue().getS() != null) {
                        jsonWriter.key("S").value(keyListValue.getValue().getS());
                    }
                    if (keyListValue.getValue().getN() != null) {
                        jsonWriter.key("N").value(keyListValue.getValue().getN());
                    }
                    if (keyListValue.getValue().getB() != null) {
                        jsonWriter.key("B").value(keyListValue.getValue().getB());
                    }
                    if ((sSList = keyListValue.getValue().getSS()) != null) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList) {
                            if (sSListValue == null) continue;
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList = keyListValue.getValue().getNS()) != null) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList) {
                            if (nSListValue == null) continue;
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((bSList = keyListValue.getValue().getBS()) != null) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList) {
                            if (bSListValue == null) continue;
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if ((attributesToGetList = getItemRequest.getAttributesToGet()) != null) {
                jsonWriter.key("AttributesToGet");
                jsonWriter.array();
                for (String attributesToGetListValue : attributesToGetList) {
                    if (attributesToGetListValue == null) continue;
                    jsonWriter.value(attributesToGetListValue);
                }
                jsonWriter.endArray();
            }
            if (getItemRequest.isConsistentRead() != null) {
                jsonWriter.key("ConsistentRead").value(getItemRequest.isConsistentRead());
            }
            if (getItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(getItemRequest.getReturnConsumedCapacity());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

