/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticbeanstalk.model.AutoScalingGroup;
import com.amazonaws.services.elasticbeanstalk.model.Instance;
import com.amazonaws.services.elasticbeanstalk.model.LaunchConfiguration;
import com.amazonaws.services.elasticbeanstalk.model.LoadBalancer;
import com.amazonaws.services.elasticbeanstalk.model.Trigger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentResourceDescription
implements Serializable {
    private String environmentName;
    private ListWithAutoConstructFlag<AutoScalingGroup> autoScalingGroups;
    private ListWithAutoConstructFlag<Instance> instances;
    private ListWithAutoConstructFlag<LaunchConfiguration> launchConfigurations;
    private ListWithAutoConstructFlag<LoadBalancer> loadBalancers;
    private ListWithAutoConstructFlag<Trigger> triggers;

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public EnvironmentResourceDescription withEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public List<AutoScalingGroup> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new ListWithAutoConstructFlag();
            this.autoScalingGroups.setAutoConstruct(true);
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        ListWithAutoConstructFlag autoScalingGroupsCopy = new ListWithAutoConstructFlag(autoScalingGroups.size());
        autoScalingGroupsCopy.addAll(autoScalingGroups);
        this.autoScalingGroups = autoScalingGroupsCopy;
    }

    public EnvironmentResourceDescription withAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
        if (this.getAutoScalingGroups() == null) {
            this.setAutoScalingGroups(new ArrayList<AutoScalingGroup>(autoScalingGroups.length));
        }
        for (AutoScalingGroup value : autoScalingGroups) {
            this.getAutoScalingGroups().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
        } else {
            ListWithAutoConstructFlag autoScalingGroupsCopy = new ListWithAutoConstructFlag(autoScalingGroups.size());
            autoScalingGroupsCopy.addAll(autoScalingGroups);
            this.autoScalingGroups = autoScalingGroupsCopy;
        }
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ListWithAutoConstructFlag();
            this.instances.setAutoConstruct(true);
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public EnvironmentResourceDescription withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public List<LaunchConfiguration> getLaunchConfigurations() {
        if (this.launchConfigurations == null) {
            this.launchConfigurations = new ListWithAutoConstructFlag();
            this.launchConfigurations.setAutoConstruct(true);
        }
        return this.launchConfigurations;
    }

    public void setLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
        if (launchConfigurations == null) {
            this.launchConfigurations = null;
            return;
        }
        ListWithAutoConstructFlag launchConfigurationsCopy = new ListWithAutoConstructFlag(launchConfigurations.size());
        launchConfigurationsCopy.addAll(launchConfigurations);
        this.launchConfigurations = launchConfigurationsCopy;
    }

    public EnvironmentResourceDescription withLaunchConfigurations(LaunchConfiguration ... launchConfigurations) {
        if (this.getLaunchConfigurations() == null) {
            this.setLaunchConfigurations(new ArrayList<LaunchConfiguration>(launchConfigurations.length));
        }
        for (LaunchConfiguration value : launchConfigurations) {
            this.getLaunchConfigurations().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
        if (launchConfigurations == null) {
            this.launchConfigurations = null;
        } else {
            ListWithAutoConstructFlag launchConfigurationsCopy = new ListWithAutoConstructFlag(launchConfigurations.size());
            launchConfigurationsCopy.addAll(launchConfigurations);
            this.launchConfigurations = launchConfigurationsCopy;
        }
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ListWithAutoConstructFlag();
            this.loadBalancers.setAutoConstruct(true);
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        ListWithAutoConstructFlag loadBalancersCopy = new ListWithAutoConstructFlag(loadBalancers.size());
        loadBalancersCopy.addAll(loadBalancers);
        this.loadBalancers = loadBalancersCopy;
    }

    public EnvironmentResourceDescription withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.getLoadBalancers() == null) {
            this.setLoadBalancers(new ArrayList<LoadBalancer>(loadBalancers.length));
        }
        for (LoadBalancer value : loadBalancers) {
            this.getLoadBalancers().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
        } else {
            ListWithAutoConstructFlag loadBalancersCopy = new ListWithAutoConstructFlag(loadBalancers.size());
            loadBalancersCopy.addAll(loadBalancers);
            this.loadBalancers = loadBalancersCopy;
        }
        return this;
    }

    public List<Trigger> getTriggers() {
        if (this.triggers == null) {
            this.triggers = new ListWithAutoConstructFlag();
            this.triggers.setAutoConstruct(true);
        }
        return this.triggers;
    }

    public void setTriggers(Collection<Trigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
            return;
        }
        ListWithAutoConstructFlag triggersCopy = new ListWithAutoConstructFlag(triggers.size());
        triggersCopy.addAll(triggers);
        this.triggers = triggersCopy;
    }

    public EnvironmentResourceDescription withTriggers(Trigger ... triggers) {
        if (this.getTriggers() == null) {
            this.setTriggers(new ArrayList<Trigger>(triggers.length));
        }
        for (Trigger value : triggers) {
            this.getTriggers().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withTriggers(Collection<Trigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
        } else {
            ListWithAutoConstructFlag triggersCopy = new ListWithAutoConstructFlag(triggers.size());
            triggersCopy.addAll(triggers);
            this.triggers = triggersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: " + this.getEnvironmentName() + ",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: " + this.getAutoScalingGroups() + ",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getLaunchConfigurations() != null) {
            sb.append("LaunchConfigurations: " + this.getLaunchConfigurations() + ",");
        }
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: " + this.getLoadBalancers() + ",");
        }
        if (this.getTriggers() != null) {
            sb.append("Triggers: " + this.getTriggers());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : ((Object)this.getAutoScalingGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : ((Object)this.getInstances()).hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurations() == null ? 0 : ((Object)this.getLaunchConfigurations()).hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : ((Object)this.getLoadBalancers()).hashCode());
        hashCode = 31 * hashCode + (this.getTriggers() == null ? 0 : ((Object)this.getTriggers()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResourceDescription)) {
            return false;
        }
        EnvironmentResourceDescription other = (EnvironmentResourceDescription)obj;
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !((Object)other.getAutoScalingGroups()).equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !((Object)other.getInstances()).equals(this.getInstances())) {
            return false;
        }
        if (other.getLaunchConfigurations() == null ^ this.getLaunchConfigurations() == null) {
            return false;
        }
        if (other.getLaunchConfigurations() != null && !((Object)other.getLaunchConfigurations()).equals(this.getLaunchConfigurations())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !((Object)other.getLoadBalancers()).equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getTriggers() == null ^ this.getTriggers() == null) {
            return false;
        }
        return other.getTriggers() == null || ((Object)other.getTriggers()).equals(this.getTriggers());
    }
}

