/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.CustomErrorResponse;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomErrorResponseStaxUnmarshaller
implements Unmarshaller<CustomErrorResponse, StaxUnmarshallerContext> {
    private static CustomErrorResponseStaxUnmarshaller instance;

    @Override
    public CustomErrorResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomErrorResponse customErrorResponse = new CustomErrorResponse();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return customErrorResponse;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ErrorCode", targetDepth)) {
                    customErrorResponse.setErrorCode(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResponsePagePath", targetDepth)) {
                    customErrorResponse.setResponsePagePath(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResponseCode", targetDepth)) {
                    customErrorResponse.setResponseCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ErrorCachingMinTTL", targetDepth)) continue;
                customErrorResponse.setErrorCachingMinTTL(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return customErrorResponse;
    }

    public static CustomErrorResponseStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CustomErrorResponseStaxUnmarshaller();
        }
        return instance;
    }
}

