/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.net.InetAddress;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;

public class AwsHostNameUtils {
    private static final Pattern S3_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?s3[.-]([a-z0-9-]+)$");

    @Deprecated
    public static String parseRegionName(URI endpoint) {
        return AwsHostNameUtils.parseRegionName(endpoint.getHost(), null);
    }

    public static String parseRegionName(String host, String serviceHint) {
        Pattern pattern;
        Matcher matcher;
        if (host.endsWith(".amazonaws.com")) {
            int index = host.length() - ".amazonaws.com".length();
            return AwsHostNameUtils.parseStandardRegionName(host.substring(0, index));
        }
        if (serviceHint != null && (matcher = (pattern = Pattern.compile("^(?:.+\\.)?" + Pattern.quote(serviceHint) + "[.-]([a-z0-9-]+)\\.")).matcher(host)).find()) {
            return matcher.group(1);
        }
        return "us-east-1";
    }

    private static String parseStandardRegionName(String fragment) {
        if (fragment.endsWith(".s3")) {
            return "us-east-1";
        }
        Matcher matcher = S3_ENDPOINT_PATTERN.matcher(fragment);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        int index = fragment.lastIndexOf(46);
        if (index == -1) {
            return "us-east-1";
        }
        String region = fragment.substring(index + 1);
        if ("us-gov".equals(region)) {
            region = "us-gov-west-1";
        }
        return region;
    }

    @Deprecated
    public static String parseServiceName(URI endpoint) {
        String host = endpoint.getHost();
        if (!host.endsWith(".amazonaws.com")) {
            throw new IllegalArgumentException("Cannot parse a service name from an unrecognized endpoint (" + host + ").");
        }
        String serviceAndRegion = host.substring(0, host.indexOf(".amazonaws.com"));
        if (serviceAndRegion.endsWith(".s3") || S3_ENDPOINT_PATTERN.matcher(serviceAndRegion).matches()) {
            return "s3";
        }
        int separator = 46;
        if (serviceAndRegion.indexOf(separator) == -1) {
            return serviceAndRegion;
        }
        String service = serviceAndRegion.substring(0, serviceAndRegion.indexOf(separator));
        return service;
    }

    public static String localHostName() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            return localhost.getHostName();
        }
        catch (Exception e) {
            LogFactory.getLog(AwsHostNameUtils.class).debug((Object)"Failed to determine the local hostname; fall back to use \"localhost\".", (Throwable)e);
            return "localhost";
        }
    }
}

