/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.metrics.RequestMetricCollector;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AwsSdkMetrics {

    public static final String METRICS_NAMESPACE = "AWSSDK/Java";
    public static final String DEFAULT_METRICS_SYSTEM_PROPERTY = "com.amazonaws.sdk.enableDefaultMetrics";
    private static final String DEFAULT_REQUEST_METRIC_COLLECTOR_FACTORY = "com.amazonaws.metrics.internal.cloudwatch.DefaultRequestMetricCollectorFactory";
    private static final boolean defaultMetricsEnabled = System.getProperty("com.amazonaws.sdk.enableDefaultMetrics") != null;
    private static volatile RequestMetricCollector mc;
    private static boolean dirtyEnabling;

    public static <T extends RequestMetricCollector> T getRequestMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        RequestMetricCollector t = mc == null ? RequestMetricCollector.NONE : mc;
        return (T)t;
    }

    public static synchronized void setRequestMetricCollector(RequestMetricCollector mc) {
        RequestMetricCollector old = AwsSdkMetrics.mc;
        AwsSdkMetrics.mc = mc;
        if (old != null) {
            old.stop();
        }
    }

    public static boolean isDefaultMetricsEnabled() {
        return defaultMetricsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void enableDefaultMetrics() {
        if (mc == null) {
            if (dirtyEnabling) {
                throw new IllegalStateException("Reentrancy is not allowed");
            }
            dirtyEnabling = true;
            try {
                Class<?> c = Class.forName(DEFAULT_REQUEST_METRIC_COLLECTOR_FACTORY);
                RequestMetricCollector.Factory f = (RequestMetricCollector.Factory)c.newInstance();
                RequestMetricCollector instance = f.getInstance();
                if (instance != null) {
                    AwsSdkMetrics.setRequestMetricCollector(instance);
                    return;
                }
            }
            catch (Exception e) {
                LogFactory.getLog(AwsSdkMetrics.class).warn((Object)"Failed to enable the default metrics", (Throwable)e);
            }
            finally {
                dirtyEnabling = false;
            }
        }
    }
}

