/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.directconnect.AmazonDirectConnect;
import com.amazonaws.services.directconnect.model.CreateConnectionRequest;
import com.amazonaws.services.directconnect.model.CreateConnectionResult;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.DeleteConnectionRequest;
import com.amazonaws.services.directconnect.model.DeleteConnectionResult;
import com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionDetailRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionDetailResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionsRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionsResult;
import com.amazonaws.services.directconnect.model.DescribeOfferingDetailRequest;
import com.amazonaws.services.directconnect.model.DescribeOfferingDetailResult;
import com.amazonaws.services.directconnect.model.DescribeOfferingsRequest;
import com.amazonaws.services.directconnect.model.DescribeOfferingsResult;
import com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest;
import com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysResult;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesResult;
import com.amazonaws.services.directconnect.model.transform.CreateConnectionRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateConnectionResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePrivateVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePrivateVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePublicVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePublicVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteConnectionRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteConnectionResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionDetailRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionDetailResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeOfferingDetailRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeOfferingDetailResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeOfferingsRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeOfferingsResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualGatewaysRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualGatewaysResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualInterfacesRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualInterfacesResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DirectConnectClientExceptionUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DirectConnectServerExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonDirectConnectClient
extends AmazonWebServiceClient
implements AmazonDirectConnect {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDirectConnect.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonDirectConnectClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonDirectConnectClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonDirectConnectClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonDirectConnectClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new DirectConnectServerExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DirectConnectClientExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("directConnect.us-east-1.amazonaws.com/");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("directconnect");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/directconnect/request.handlers"));
    }

    @Override
    public DescribeVirtualInterfacesResult describeVirtualInterfaces(DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualInterfacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeVirtualInterfacesRequest> request = new DescribeVirtualInterfacesRequestMarshaller().marshall(describeVirtualInterfacesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeVirtualInterfacesResultJsonUnmarshaller unmarshaller = new DescribeVirtualInterfacesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeVirtualInterfacesResult> responseHandler = new JsonResponseHandler<DescribeVirtualInterfacesResult>(unmarshaller);
        return (DescribeVirtualInterfacesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeVirtualGatewaysResult describeVirtualGateways(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualGatewaysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeVirtualGatewaysRequest> request = new DescribeVirtualGatewaysRequestMarshaller().marshall(describeVirtualGatewaysRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeVirtualGatewaysResultJsonUnmarshaller unmarshaller = new DescribeVirtualGatewaysResultJsonUnmarshaller();
        JsonResponseHandler<DescribeVirtualGatewaysResult> responseHandler = new JsonResponseHandler<DescribeVirtualGatewaysResult>(unmarshaller);
        return (DescribeVirtualGatewaysResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeConnectionDetailResult describeConnectionDetail(DescribeConnectionDetailRequest describeConnectionDetailRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeConnectionDetailRequest> request = new DescribeConnectionDetailRequestMarshaller().marshall(describeConnectionDetailRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeConnectionDetailResultJsonUnmarshaller unmarshaller = new DescribeConnectionDetailResultJsonUnmarshaller();
        JsonResponseHandler<DescribeConnectionDetailResult> responseHandler = new JsonResponseHandler<DescribeConnectionDetailResult>(unmarshaller);
        return (DescribeConnectionDetailResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeOfferingsResult describeOfferings(DescribeOfferingsRequest describeOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeOfferingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeOfferingsRequest> request = new DescribeOfferingsRequestMarshaller().marshall(describeOfferingsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeOfferingsResultJsonUnmarshaller unmarshaller = new DescribeOfferingsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeOfferingsResult> responseHandler = new JsonResponseHandler<DescribeOfferingsResult>(unmarshaller);
        return (DescribeOfferingsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeConnectionsResult describeConnections(DescribeConnectionsRequest describeConnectionsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeConnectionsRequest> request = new DescribeConnectionsRequestMarshaller().marshall(describeConnectionsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeConnectionsResultJsonUnmarshaller unmarshaller = new DescribeConnectionsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeConnectionsResult> responseHandler = new JsonResponseHandler<DescribeConnectionsResult>(unmarshaller);
        return (DescribeConnectionsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeOfferingDetailResult describeOfferingDetail(DescribeOfferingDetailRequest describeOfferingDetailRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeOfferingDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeOfferingDetailRequest> request = new DescribeOfferingDetailRequestMarshaller().marshall(describeOfferingDetailRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeOfferingDetailResultJsonUnmarshaller unmarshaller = new DescribeOfferingDetailResultJsonUnmarshaller();
        JsonResponseHandler<DescribeOfferingDetailResult> responseHandler = new JsonResponseHandler<DescribeOfferingDetailResult>(unmarshaller);
        return (DescribeOfferingDetailResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DeleteConnectionResult deleteConnection(DeleteConnectionRequest deleteConnectionRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteConnectionRequest> request = new DeleteConnectionRequestMarshaller().marshall(deleteConnectionRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeleteConnectionResultJsonUnmarshaller unmarshaller = new DeleteConnectionResultJsonUnmarshaller();
        JsonResponseHandler<DeleteConnectionResult> responseHandler = new JsonResponseHandler<DeleteConnectionResult>(unmarshaller);
        return (DeleteConnectionResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreateConnectionResult createConnection(CreateConnectionRequest createConnectionRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(createConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreateConnectionRequest> request = new CreateConnectionRequestMarshaller().marshall(createConnectionRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreateConnectionResultJsonUnmarshaller unmarshaller = new CreateConnectionResultJsonUnmarshaller();
        JsonResponseHandler<CreateConnectionResult> responseHandler = new JsonResponseHandler<CreateConnectionResult>(unmarshaller);
        return (CreateConnectionResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreatePrivateVirtualInterfaceResult createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(createPrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreatePrivateVirtualInterfaceRequest> request = new CreatePrivateVirtualInterfaceRequestMarshaller().marshall(createPrivateVirtualInterfaceRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreatePrivateVirtualInterfaceResultJsonUnmarshaller unmarshaller = new CreatePrivateVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<CreatePrivateVirtualInterfaceResult> responseHandler = new JsonResponseHandler<CreatePrivateVirtualInterfaceResult>(unmarshaller);
        return (CreatePrivateVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DeleteVirtualInterfaceResult deleteVirtualInterface(DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteVirtualInterfaceRequest> request = new DeleteVirtualInterfaceRequestMarshaller().marshall(deleteVirtualInterfaceRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeleteVirtualInterfaceResultJsonUnmarshaller unmarshaller = new DeleteVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<DeleteVirtualInterfaceResult> responseHandler = new JsonResponseHandler<DeleteVirtualInterfaceResult>(unmarshaller);
        return (DeleteVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreatePublicVirtualInterfaceResult createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(createPublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreatePublicVirtualInterfaceRequest> request = new CreatePublicVirtualInterfaceRequestMarshaller().marshall(createPublicVirtualInterfaceRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreatePublicVirtualInterfaceResultJsonUnmarshaller unmarshaller = new CreatePublicVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<CreatePublicVirtualInterfaceResult> responseHandler = new JsonResponseHandler<CreatePublicVirtualInterfaceResult>(unmarshaller);
        return (CreatePublicVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeVirtualInterfacesResult describeVirtualInterfaces() throws AmazonServiceException, AmazonClientException {
        return this.describeVirtualInterfaces(new DescribeVirtualInterfacesRequest());
    }

    @Override
    public DescribeVirtualGatewaysResult describeVirtualGateways() throws AmazonServiceException, AmazonClientException {
        return this.describeVirtualGateways(new DescribeVirtualGatewaysRequest());
    }

    @Override
    public DescribeOfferingsResult describeOfferings() throws AmazonServiceException, AmazonClientException {
        return this.describeOfferings(new DescribeOfferingsRequest());
    }

    @Override
    public DescribeConnectionsResult describeConnections() throws AmazonServiceException, AmazonClientException {
        return this.describeConnections(new DescribeConnectionsRequest());
    }

    @Override
    public CreatePrivateVirtualInterfaceResult createPrivateVirtualInterface() throws AmazonServiceException, AmazonClientException {
        return this.createPrivateVirtualInterface(new CreatePrivateVirtualInterfaceRequest());
    }

    @Override
    public DeleteVirtualInterfaceResult deleteVirtualInterface() throws AmazonServiceException, AmazonClientException {
        return this.deleteVirtualInterface(new DeleteVirtualInterfaceRequest());
    }

    @Override
    public CreatePublicVirtualInterfaceResult createPublicVirtualInterface() throws AmazonServiceException, AmazonClientException {
        return this.createPublicVirtualInterface(new CreatePublicVirtualInterfaceRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "directconnect";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        awsRequestMetrics.log();
        return (X)result;
    }
}

