/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddJobFlowStepsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ModifyInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SetTerminationProtectionRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SetVisibleToAllUsersRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TerminateJobFlowsRequestMarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticMapReduceClient
extends AmazonWebServiceClient
implements AmazonElasticMapReduce {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticMapReduce.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonElasticMapReduceClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("elasticmapreduce.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("elasticmapreduce");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticmapreduce/request.handlers"));
    }

    @Override
    public void setVisibleToAllUsers(SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(setVisibleToAllUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<SetVisibleToAllUsersRequest> request = new SetVisibleToAllUsersRequestMarshaller().marshall(setVisibleToAllUsersRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public AddInstanceGroupsResult addInstanceGroups(AddInstanceGroupsRequest addInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(addInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<AddInstanceGroupsRequest> request = new AddInstanceGroupsRequestMarshaller().marshall(addInstanceGroupsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        AddInstanceGroupsResultJsonUnmarshaller unmarshaller = new AddInstanceGroupsResultJsonUnmarshaller();
        JsonResponseHandler<AddInstanceGroupsResult> responseHandler = new JsonResponseHandler<AddInstanceGroupsResult>(unmarshaller);
        return (AddInstanceGroupsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void addJobFlowSteps(AddJobFlowStepsRequest addJobFlowStepsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(addJobFlowStepsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<AddJobFlowStepsRequest> request = new AddJobFlowStepsRequestMarshaller().marshall(addJobFlowStepsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void terminateJobFlows(TerminateJobFlowsRequest terminateJobFlowsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(terminateJobFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<TerminateJobFlowsRequest> request = new TerminateJobFlowsRequestMarshaller().marshall(terminateJobFlowsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeJobFlowsResult describeJobFlows(DescribeJobFlowsRequest describeJobFlowsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeJobFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeJobFlowsRequest> request = new DescribeJobFlowsRequestMarshaller().marshall(describeJobFlowsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeJobFlowsResultJsonUnmarshaller unmarshaller = new DescribeJobFlowsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeJobFlowsResult> responseHandler = new JsonResponseHandler<DescribeJobFlowsResult>(unmarshaller);
        return (DescribeJobFlowsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void setTerminationProtection(SetTerminationProtectionRequest setTerminationProtectionRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(setTerminationProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<SetTerminationProtectionRequest> request = new SetTerminationProtectionRequestMarshaller().marshall(setTerminationProtectionRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public RunJobFlowResult runJobFlow(RunJobFlowRequest runJobFlowRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(runJobFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<RunJobFlowRequest> request = new RunJobFlowRequestMarshaller().marshall(runJobFlowRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        RunJobFlowResultJsonUnmarshaller unmarshaller = new RunJobFlowResultJsonUnmarshaller();
        JsonResponseHandler<RunJobFlowResult> responseHandler = new JsonResponseHandler<RunJobFlowResult>(unmarshaller);
        return (RunJobFlowResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void modifyInstanceGroups(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(modifyInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ModifyInstanceGroupsRequest> request = new ModifyInstanceGroupsRequestMarshaller().marshall(modifyInstanceGroupsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeJobFlowsResult describeJobFlows() throws AmazonServiceException, AmazonClientException {
        return this.describeJobFlows(new DescribeJobFlowsRequest());
    }

    @Override
    public void modifyInstanceGroups() throws AmazonServiceException, AmazonClientException {
        this.modifyInstanceGroups(new ModifyInstanceGroupsRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "elasticmapreduce";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        awsRequestMetrics.log();
        return (X)result;
    }
}

