
/**
 * Synchronous and asynchronous client classes for accessing AmazonRedshift.
 *
 * Amazon Redshift <b>Overview</b> <p>
 * This is the Amazon Redshift API Reference. This guide provides descriptions and samples of the Amazon Redshift API.
 * </p>
 * <p>
 * Amazon Redshift manages all the work of setting up, operating, and scaling a data warehouse: provisioning capacity, monitoring and backing up the
 * cluster, and applying patches and upgrades to the Amazon Redshift engine. You can focus on using your data to acquire new insights for your business
 * and customers.
 * </p>
 * <b>Are You a First-Time Amazon Redshift User?</b> <p>
 * If you are a first-time user of Amazon Redshift, we recommend that you begin by reading the following sections:
 * </p>
 * <p>
 * 
 * <ul>
 * <li> <p>
 * <i>Service Highlights and Pricing</i> - The <a href="http://aws.amazon.com/redshift/"> product detail page </a> provides the Amazon Redshift value
 * proposition, service highlights and pricing.
 * </p>
 * </li>
 * <li> <p>
 * <i>Getting Started</i> - The <a href="http://docs.aws.amazon.com/redshift/latest/gsg/getting-started.html"> Getting Started Guide </a> includes an
 * example that walks you through the process of creating a cluster, creating database tables, uploading data, and testing queries.
 * </p>
 * </li>
 * 
 * </ul>
 * 
 * </p>
 * <p>
 * After you complete the Getting Started Guide, we recommend that you explore one of the following guides:
 * </p>
 * 
 * <ul>
 * <li> <p>
 * <i>Cluster Management</i> - If you are responsible for managing Amazon Redshift clusters, the <a
 * href="http://docs.aws.amazon.com/redshift/latest/mgmt/welcome.html"> Cluster Management Guide </a> shows you how to create and manage Amazon Redshift
 * clusters.
 * </p>
 * <p>
 * If you are an application developer, you can use the Amazon Redshift Query API to manage clusters programmatically. Additionally, the AWS SDK
 * libraries that wrap the underlying Amazon Redshift API simplify your programming tasks. If you prefer a more interactive way of managing clusters,
 * you can use the Amazon Redshift console and the AWS command line interface (AWS CLI). For information about the API and CLI, go to the following
 * manuals :
 * </p>
 * 
 * <ul>
 * <li> <p>
 * API Reference ( <i>this document</i> )
 * </p>
 * </li>
 * <li> <p>
 * <a href="http://docs.aws.amazon.com/redshift/latest/cli"> CLI Reference </a>
 * </p>
 * </li>
 * 
 * </ul>
 * </li>
 * <li> <p>
 * <i>Amazon Redshift Database Database Developer</i> - If you are a database developer, the Amazon Redshift <a
 * href="http://docs.aws.amazon.com/redshift/latest/dg/"> Database Developer Guide </a> explains how to design, build, query, and maintain the databases
 * that make up your data warehouse.
 * </p>
 * </li>
 * 
 * </ul>
 * <p>
 * For a list of supported AWS regions where you can provision a cluster, go to the <a
 * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region"> Regions and Endpoints </a> section in the <i>Amazon Web Services
 * Glossary</i> .
 * </p>
 */
 package com.amazonaws.services.redshift;
        