/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.datapipeline.DataPipeline;
import com.amazonaws.services.datapipeline.model.ActivatePipelineRequest;
import com.amazonaws.services.datapipeline.model.ActivatePipelineResult;
import com.amazonaws.services.datapipeline.model.CreatePipelineRequest;
import com.amazonaws.services.datapipeline.model.CreatePipelineResult;
import com.amazonaws.services.datapipeline.model.DeletePipelineRequest;
import com.amazonaws.services.datapipeline.model.DescribeObjectsRequest;
import com.amazonaws.services.datapipeline.model.DescribeObjectsResult;
import com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.amazonaws.services.datapipeline.model.DescribePipelinesResult;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionResult;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.ListPipelinesRequest;
import com.amazonaws.services.datapipeline.model.ListPipelinesResult;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.services.datapipeline.model.PollForTaskResult;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.QueryObjectsResult;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressResult;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatResult;
import com.amazonaws.services.datapipeline.model.SetStatusRequest;
import com.amazonaws.services.datapipeline.model.SetTaskStatusRequest;
import com.amazonaws.services.datapipeline.model.SetTaskStatusResult;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.transform.ActivatePipelineRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ActivatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.CreatePipelineRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.DeletePipelineRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribeObjectsRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribeObjectsResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribePipelinesRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribePipelinesResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.EvaluateExpressionRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.EvaluateExpressionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.GetPipelineDefinitionRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.GetPipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.InternalServiceErrorExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ListPipelinesRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PipelineDeletedExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PipelineNotFoundExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PollForTaskRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PollForTaskResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PutPipelineDefinitionRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PutPipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.QueryObjectsRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.QueryObjectsResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskProgressRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskProgressResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskRunnerHeartbeatRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskRunnerHeartbeatResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetStatusRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetTaskStatusRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetTaskStatusResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.TaskNotFoundExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ValidatePipelineDefinitionRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ValidatePipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPipelineClient
extends AmazonWebServiceClient
implements DataPipeline {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(DataPipeline.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public DataPipelineClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public DataPipelineClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public DataPipelineClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public DataPipelineClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public DataPipelineClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public DataPipelineClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new PipelineNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServiceErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TaskNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PipelineDeletedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("datapipeline.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("datapipeline");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/datapipeline/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivatePipelineResult activatePipeline(ActivatePipelineRequest activatePipelineRequest) throws AmazonServiceException, AmazonClientException {
        Request<ActivatePipelineRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(activatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ActivatePipelineRequestMarshaller().marshall(activatePipelineRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ActivatePipelineResultJsonUnmarshaller unmarshaller = new ActivatePipelineResultJsonUnmarshaller();
        JsonResponseHandler<ActivatePipelineResult> responseHandler = new JsonResponseHandler<ActivatePipelineResult>(unmarshaller);
        return (ActivatePipelineResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest listPipelinesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListPipelinesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ListPipelinesRequestMarshaller().marshall(listPipelinesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ListPipelinesResultJsonUnmarshaller unmarshaller = new ListPipelinesResultJsonUnmarshaller();
        JsonResponseHandler<ListPipelinesResult> responseHandler = new JsonResponseHandler<ListPipelinesResult>(unmarshaller);
        return (ListPipelinesResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportTaskProgressResult reportTaskProgress(ReportTaskProgressRequest reportTaskProgressRequest) throws AmazonServiceException, AmazonClientException {
        Request<ReportTaskProgressRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(reportTaskProgressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ReportTaskProgressRequestMarshaller().marshall(reportTaskProgressRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ReportTaskProgressResultJsonUnmarshaller unmarshaller = new ReportTaskProgressResultJsonUnmarshaller();
        JsonResponseHandler<ReportTaskProgressResult> responseHandler = new JsonResponseHandler<ReportTaskProgressResult>(unmarshaller);
        return (ReportTaskProgressResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidatePipelineDefinitionResult validatePipelineDefinition(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        Request<ValidatePipelineDefinitionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(validatePipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ValidatePipelineDefinitionRequestMarshaller().marshall(validatePipelineDefinitionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ValidatePipelineDefinitionResultJsonUnmarshaller unmarshaller = new ValidatePipelineDefinitionResultJsonUnmarshaller();
        JsonResponseHandler<ValidatePipelineDefinitionResult> responseHandler = new JsonResponseHandler<ValidatePipelineDefinitionResult>(unmarshaller);
        return (ValidatePipelineDefinitionResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForTaskResult pollForTask(PollForTaskRequest pollForTaskRequest) throws AmazonServiceException, AmazonClientException {
        Request<PollForTaskRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(pollForTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new PollForTaskRequestMarshaller().marshall(pollForTaskRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        PollForTaskResultJsonUnmarshaller unmarshaller = new PollForTaskResultJsonUnmarshaller();
        JsonResponseHandler<PollForTaskResult> responseHandler = new JsonResponseHandler<PollForTaskResult>(unmarshaller);
        return (PollForTaskResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryObjectsResult queryObjects(QueryObjectsRequest queryObjectsRequest) throws AmazonServiceException, AmazonClientException {
        Request<QueryObjectsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(queryObjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new QueryObjectsRequestMarshaller().marshall(queryObjectsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        QueryObjectsResultJsonUnmarshaller unmarshaller = new QueryObjectsResultJsonUnmarshaller();
        JsonResponseHandler<QueryObjectsResult> responseHandler = new JsonResponseHandler<QueryObjectsResult>(unmarshaller);
        return (QueryObjectsResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(SetStatusRequest setStatusRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetStatusRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(setStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SetStatusRequestMarshaller().marshall(setStatusRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePipeline(DeletePipelineRequest deletePipelineRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeletePipelineRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeletePipelineRequestMarshaller().marshall(deletePipelineRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineDefinitionResult getPipelineDefinition(GetPipelineDefinitionRequest getPipelineDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetPipelineDefinitionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(getPipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new GetPipelineDefinitionRequestMarshaller().marshall(getPipelineDefinitionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        GetPipelineDefinitionResultJsonUnmarshaller unmarshaller = new GetPipelineDefinitionResultJsonUnmarshaller();
        JsonResponseHandler<GetPipelineDefinitionResult> responseHandler = new JsonResponseHandler<GetPipelineDefinitionResult>(unmarshaller);
        return (GetPipelineDefinitionResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetTaskStatusResult setTaskStatus(SetTaskStatusRequest setTaskStatusRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetTaskStatusRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(setTaskStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SetTaskStatusRequestMarshaller().marshall(setTaskStatusRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        SetTaskStatusResultJsonUnmarshaller unmarshaller = new SetTaskStatusResultJsonUnmarshaller();
        JsonResponseHandler<SetTaskStatusResult> responseHandler = new JsonResponseHandler<SetTaskStatusResult>(unmarshaller);
        return (SetTaskStatusResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluateExpressionResult evaluateExpression(EvaluateExpressionRequest evaluateExpressionRequest) throws AmazonServiceException, AmazonClientException {
        Request<EvaluateExpressionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(evaluateExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new EvaluateExpressionRequestMarshaller().marshall(evaluateExpressionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        EvaluateExpressionResultJsonUnmarshaller unmarshaller = new EvaluateExpressionResultJsonUnmarshaller();
        JsonResponseHandler<EvaluateExpressionResult> responseHandler = new JsonResponseHandler<EvaluateExpressionResult>(unmarshaller);
        return (EvaluateExpressionResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePipelinesResult describePipelines(DescribePipelinesRequest describePipelinesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribePipelinesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describePipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribePipelinesRequestMarshaller().marshall(describePipelinesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribePipelinesResultJsonUnmarshaller unmarshaller = new DescribePipelinesResultJsonUnmarshaller();
        JsonResponseHandler<DescribePipelinesResult> responseHandler = new JsonResponseHandler<DescribePipelinesResult>(unmarshaller);
        return (DescribePipelinesResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest createPipelineRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreatePipelineRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CreatePipelineRequestMarshaller().marshall(createPipelineRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        CreatePipelineResultJsonUnmarshaller unmarshaller = new CreatePipelineResultJsonUnmarshaller();
        JsonResponseHandler<CreatePipelineResult> responseHandler = new JsonResponseHandler<CreatePipelineResult>(unmarshaller);
        return (CreatePipelineResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeObjectsResult describeObjects(DescribeObjectsRequest describeObjectsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeObjectsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeObjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeObjectsRequestMarshaller().marshall(describeObjectsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeObjectsResultJsonUnmarshaller unmarshaller = new DescribeObjectsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeObjectsResult> responseHandler = new JsonResponseHandler<DescribeObjectsResult>(unmarshaller);
        return (DescribeObjectsResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportTaskRunnerHeartbeatResult reportTaskRunnerHeartbeat(ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) throws AmazonServiceException, AmazonClientException {
        Request<ReportTaskRunnerHeartbeatRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(reportTaskRunnerHeartbeatRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ReportTaskRunnerHeartbeatRequestMarshaller().marshall(reportTaskRunnerHeartbeatRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ReportTaskRunnerHeartbeatResultJsonUnmarshaller unmarshaller = new ReportTaskRunnerHeartbeatResultJsonUnmarshaller();
        JsonResponseHandler<ReportTaskRunnerHeartbeatResult> responseHandler = new JsonResponseHandler<ReportTaskRunnerHeartbeatResult>(unmarshaller);
        return (ReportTaskRunnerHeartbeatResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPipelineDefinitionResult putPipelineDefinition(PutPipelineDefinitionRequest putPipelineDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutPipelineDefinitionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(putPipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new PutPipelineDefinitionRequestMarshaller().marshall(putPipelineDefinitionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        PutPipelineDefinitionResultJsonUnmarshaller unmarshaller = new PutPipelineDefinitionResultJsonUnmarshaller();
        JsonResponseHandler<PutPipelineDefinitionResult> responseHandler = new JsonResponseHandler<PutPipelineDefinitionResult>(unmarshaller);
        return (PutPipelineDefinitionResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListPipelinesResult listPipelines() throws AmazonServiceException, AmazonClientException {
        return this.listPipelines(new ListPipelinesRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "datapipeline";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return (X)result;
    }
}

