/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.Artwork;
import com.amazonaws.services.elastictranscoder.model.Clip;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.CreateJobPlaylist;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.JobAlbumArt;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import com.amazonaws.services.elastictranscoder.model.JobWatermark;
import com.amazonaws.services.elastictranscoder.model.TimeSpan;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    @Override
    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateJobRequest> request = new DefaultRequest<CreateJobRequest>(createJobRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.CreateJob";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2012-09-25/jobs";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag playlistsList;
            ListWithAutoConstructFlag outputsList;
            CreateJobOutput output;
            JobInput input;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createJobRequest.getPipelineId() != null) {
                jsonWriter.key("PipelineId").value(createJobRequest.getPipelineId());
            }
            if ((input = createJobRequest.getInput()) != null) {
                jsonWriter.key("Input");
                jsonWriter.object();
                if (input.getKey() != null) {
                    jsonWriter.key("Key").value(input.getKey());
                }
                if (input.getFrameRate() != null) {
                    jsonWriter.key("FrameRate").value(input.getFrameRate());
                }
                if (input.getResolution() != null) {
                    jsonWriter.key("Resolution").value(input.getResolution());
                }
                if (input.getAspectRatio() != null) {
                    jsonWriter.key("AspectRatio").value(input.getAspectRatio());
                }
                if (input.getInterlaced() != null) {
                    jsonWriter.key("Interlaced").value(input.getInterlaced());
                }
                if (input.getContainer() != null) {
                    jsonWriter.key("Container").value(input.getContainer());
                }
                jsonWriter.endObject();
            }
            if ((output = createJobRequest.getOutput()) != null) {
                ListWithAutoConstructFlag compositionList;
                JobAlbumArt albumArt;
                ListWithAutoConstructFlag watermarksList;
                jsonWriter.key("Output");
                jsonWriter.object();
                if (output.getKey() != null) {
                    jsonWriter.key("Key").value(output.getKey());
                }
                if (output.getThumbnailPattern() != null) {
                    jsonWriter.key("ThumbnailPattern").value(output.getThumbnailPattern());
                }
                if (output.getRotate() != null) {
                    jsonWriter.key("Rotate").value(output.getRotate());
                }
                if (output.getPresetId() != null) {
                    jsonWriter.key("PresetId").value(output.getPresetId());
                }
                if (output.getSegmentDuration() != null) {
                    jsonWriter.key("SegmentDuration").value(output.getSegmentDuration());
                }
                if (!((watermarksList = (ListWithAutoConstructFlag)output.getWatermarks()) == null || watermarksList.isAutoConstruct() && watermarksList.isEmpty())) {
                    jsonWriter.key("Watermarks");
                    jsonWriter.array();
                    for (JobWatermark watermarksListValue : watermarksList) {
                        if (watermarksListValue == null) continue;
                        jsonWriter.object();
                        if (watermarksListValue.getPresetWatermarkId() != null) {
                            jsonWriter.key("PresetWatermarkId").value(watermarksListValue.getPresetWatermarkId());
                        }
                        if (watermarksListValue.getInputKey() != null) {
                            jsonWriter.key("InputKey").value(watermarksListValue.getInputKey());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if ((albumArt = output.getAlbumArt()) != null) {
                    ListWithAutoConstructFlag artworkList;
                    jsonWriter.key("AlbumArt");
                    jsonWriter.object();
                    if (albumArt.getMergePolicy() != null) {
                        jsonWriter.key("MergePolicy").value(albumArt.getMergePolicy());
                    }
                    if (!((artworkList = (ListWithAutoConstructFlag)albumArt.getArtwork()) == null || artworkList.isAutoConstruct() && artworkList.isEmpty())) {
                        jsonWriter.key("Artwork");
                        jsonWriter.array();
                        for (Artwork artworkListValue : artworkList) {
                            if (artworkListValue == null) continue;
                            jsonWriter.object();
                            if (artworkListValue.getInputKey() != null) {
                                jsonWriter.key("InputKey").value(artworkListValue.getInputKey());
                            }
                            if (artworkListValue.getMaxWidth() != null) {
                                jsonWriter.key("MaxWidth").value(artworkListValue.getMaxWidth());
                            }
                            if (artworkListValue.getMaxHeight() != null) {
                                jsonWriter.key("MaxHeight").value(artworkListValue.getMaxHeight());
                            }
                            if (artworkListValue.getSizingPolicy() != null) {
                                jsonWriter.key("SizingPolicy").value(artworkListValue.getSizingPolicy());
                            }
                            if (artworkListValue.getPaddingPolicy() != null) {
                                jsonWriter.key("PaddingPolicy").value(artworkListValue.getPaddingPolicy());
                            }
                            if (artworkListValue.getAlbumArtFormat() != null) {
                                jsonWriter.key("AlbumArtFormat").value(artworkListValue.getAlbumArtFormat());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                if (!((compositionList = (ListWithAutoConstructFlag)output.getComposition()) == null || compositionList.isAutoConstruct() && compositionList.isEmpty())) {
                    jsonWriter.key("Composition");
                    jsonWriter.array();
                    for (Clip compositionListValue : compositionList) {
                        if (compositionListValue == null) continue;
                        jsonWriter.object();
                        TimeSpan timeSpan = compositionListValue.getTimeSpan();
                        if (timeSpan != null) {
                            jsonWriter.key("TimeSpan");
                            jsonWriter.object();
                            if (timeSpan.getStartTime() != null) {
                                jsonWriter.key("StartTime").value(timeSpan.getStartTime());
                            }
                            if (timeSpan.getDuration() != null) {
                                jsonWriter.key("Duration").value(timeSpan.getDuration());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (!((outputsList = (ListWithAutoConstructFlag)createJobRequest.getOutputs()) == null || outputsList.isAutoConstruct() && outputsList.isEmpty())) {
                jsonWriter.key("Outputs");
                jsonWriter.array();
                for (CreateJobOutput outputsListValue : outputsList) {
                    ListWithAutoConstructFlag compositionList;
                    JobAlbumArt albumArt;
                    ListWithAutoConstructFlag watermarksList;
                    if (outputsListValue == null) continue;
                    jsonWriter.object();
                    if (outputsListValue.getKey() != null) {
                        jsonWriter.key("Key").value(outputsListValue.getKey());
                    }
                    if (outputsListValue.getThumbnailPattern() != null) {
                        jsonWriter.key("ThumbnailPattern").value(outputsListValue.getThumbnailPattern());
                    }
                    if (outputsListValue.getRotate() != null) {
                        jsonWriter.key("Rotate").value(outputsListValue.getRotate());
                    }
                    if (outputsListValue.getPresetId() != null) {
                        jsonWriter.key("PresetId").value(outputsListValue.getPresetId());
                    }
                    if (outputsListValue.getSegmentDuration() != null) {
                        jsonWriter.key("SegmentDuration").value(outputsListValue.getSegmentDuration());
                    }
                    if (!((watermarksList = (ListWithAutoConstructFlag)outputsListValue.getWatermarks()) == null || watermarksList.isAutoConstruct() && watermarksList.isEmpty())) {
                        jsonWriter.key("Watermarks");
                        jsonWriter.array();
                        for (JobWatermark watermarksListValue : watermarksList) {
                            if (watermarksListValue == null) continue;
                            jsonWriter.object();
                            if (watermarksListValue.getPresetWatermarkId() != null) {
                                jsonWriter.key("PresetWatermarkId").value(watermarksListValue.getPresetWatermarkId());
                            }
                            if (watermarksListValue.getInputKey() != null) {
                                jsonWriter.key("InputKey").value(watermarksListValue.getInputKey());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((albumArt = outputsListValue.getAlbumArt()) != null) {
                        ListWithAutoConstructFlag artworkList;
                        jsonWriter.key("AlbumArt");
                        jsonWriter.object();
                        if (albumArt.getMergePolicy() != null) {
                            jsonWriter.key("MergePolicy").value(albumArt.getMergePolicy());
                        }
                        if (!((artworkList = (ListWithAutoConstructFlag)albumArt.getArtwork()) == null || artworkList.isAutoConstruct() && artworkList.isEmpty())) {
                            jsonWriter.key("Artwork");
                            jsonWriter.array();
                            for (Artwork artworkListValue : artworkList) {
                                if (artworkListValue == null) continue;
                                jsonWriter.object();
                                if (artworkListValue.getInputKey() != null) {
                                    jsonWriter.key("InputKey").value(artworkListValue.getInputKey());
                                }
                                if (artworkListValue.getMaxWidth() != null) {
                                    jsonWriter.key("MaxWidth").value(artworkListValue.getMaxWidth());
                                }
                                if (artworkListValue.getMaxHeight() != null) {
                                    jsonWriter.key("MaxHeight").value(artworkListValue.getMaxHeight());
                                }
                                if (artworkListValue.getSizingPolicy() != null) {
                                    jsonWriter.key("SizingPolicy").value(artworkListValue.getSizingPolicy());
                                }
                                if (artworkListValue.getPaddingPolicy() != null) {
                                    jsonWriter.key("PaddingPolicy").value(artworkListValue.getPaddingPolicy());
                                }
                                if (artworkListValue.getAlbumArtFormat() != null) {
                                    jsonWriter.key("AlbumArtFormat").value(artworkListValue.getAlbumArtFormat());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (!((compositionList = (ListWithAutoConstructFlag)outputsListValue.getComposition()) == null || compositionList.isAutoConstruct() && compositionList.isEmpty())) {
                        jsonWriter.key("Composition");
                        jsonWriter.array();
                        for (Clip compositionListValue : compositionList) {
                            if (compositionListValue == null) continue;
                            jsonWriter.object();
                            TimeSpan timeSpan = compositionListValue.getTimeSpan();
                            if (timeSpan != null) {
                                jsonWriter.key("TimeSpan");
                                jsonWriter.object();
                                if (timeSpan.getStartTime() != null) {
                                    jsonWriter.key("StartTime").value(timeSpan.getStartTime());
                                }
                                if (timeSpan.getDuration() != null) {
                                    jsonWriter.key("Duration").value(timeSpan.getDuration());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createJobRequest.getOutputKeyPrefix() != null) {
                jsonWriter.key("OutputKeyPrefix").value(createJobRequest.getOutputKeyPrefix());
            }
            if (!((playlistsList = (ListWithAutoConstructFlag)createJobRequest.getPlaylists()) == null || playlistsList.isAutoConstruct() && playlistsList.isEmpty())) {
                jsonWriter.key("Playlists");
                jsonWriter.array();
                for (CreateJobPlaylist playlistsListValue : playlistsList) {
                    ListWithAutoConstructFlag outputKeysList;
                    if (playlistsListValue == null) continue;
                    jsonWriter.object();
                    if (playlistsListValue.getName() != null) {
                        jsonWriter.key("Name").value(playlistsListValue.getName());
                    }
                    if (playlistsListValue.getFormat() != null) {
                        jsonWriter.key("Format").value(playlistsListValue.getFormat());
                    }
                    if (!((outputKeysList = (ListWithAutoConstructFlag)playlistsListValue.getOutputKeys()) == null || outputKeysList.isAutoConstruct() && outputKeysList.isEmpty())) {
                        jsonWriter.key("OutputKeys");
                        jsonWriter.array();
                        for (String outputKeysListValue : outputKeysList) {
                            if (outputKeysListValue == null) continue;
                            jsonWriter.value(outputKeysListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

