/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.internal.cloudwatch.MachineMetric;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.util.jmx.MBeans;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MachineMetricFactory {
    private static final MachineMetric[] memoryMetrics = new MachineMetric[]{MachineMetric.TotalMemory, MachineMetric.FreeMemory, MachineMetric.UsedMemory, MachineMetric.SpareMemory};
    private static final MachineMetric[] threadMetrics = new MachineMetric[]{MachineMetric.ThreadCount, MachineMetric.DeadLockThreadCount, MachineMetric.DaemonThreadCount, MachineMetric.PeakThreadCount, MachineMetric.TotalStartedThreadCount};
    private static final MachineMetric[] fdMetrics = new MachineMetric[]{MachineMetric.OpenFileDescriptorCount, MachineMetric.SpareFileDescriptorCount};

    MachineMetricFactory() {
    }

    private void addMetrics(List<MetricDatum> list, MachineMetric[] machineMetrics, long[] values, StandardUnit unit) {
        for (int i = 0; i < machineMetrics.length; ++i) {
            MachineMetric metric = machineMetrics[i];
            long val = values[i];
            if (val == 0L && !metric.includeZeroValue()) continue;
            MetricDatum datum = new MetricDatum().withMetricName(metric.getMetricName()).withDimensions(new Dimension().withName(metric.getDimensionName()).withValue(metric.name())).withUnit(unit).withValue(Double.valueOf(val));
            list.add(datum);
        }
    }

    List<MetricDatum> generateMetrics() {
        if (AwsSdkMetrics.isMachineMetricExcluded()) {
            return Collections.emptyList();
        }
        ArrayList<MetricDatum> list = new ArrayList<MetricDatum>(MachineMetric.values().length);
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        long usedMem = totalMem - freeMem;
        long spareMem = rt.maxMemory() - usedMem;
        long[] memories = new long[]{totalMem, freeMem, usedMem, spareMem};
        this.addMetrics(list, memoryMetrics, memories, StandardUnit.Bytes);
        try {
            this.addThreadMetrics(list);
        }
        catch (Throwable t) {
            LogFactory.getLog(this.getClass()).debug((Object)"Ignoring thread metrics", t);
        }
        try {
            this.addFileDescriptorMetrics(list);
        }
        catch (Throwable t) {
            LogFactory.getLog(this.getClass()).debug((Object)"Ignoring file descriptor metrics", t);
        }
        return list;
    }

    private void addFileDescriptorMetrics(List<MetricDatum> list) throws ReflectionException, InstanceNotFoundException, MalformedObjectNameException {
        MBeanServer mbsc = MBeans.getMBeanServer();
        AttributeList attributes = mbsc.getAttributes(new ObjectName("java.lang:type=OperatingSystem"), new String[]{"OpenFileDescriptorCount", "MaxFileDescriptorCount"});
        List<Attribute> attrList = attributes.asList();
        long openFdCount = (Long)attrList.get(0).getValue();
        long maxFdCount = (Long)attrList.get(1).getValue();
        long[] fdCounts = new long[]{openFdCount, maxFdCount - openFdCount};
        this.addMetrics(list, fdMetrics, fdCounts, StandardUnit.Count);
    }

    private void addThreadMetrics(List<MetricDatum> list) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        int threadCount = threadMXBean.getThreadCount();
        long[] ids = threadMXBean.findDeadlockedThreads();
        int deadLockThreadCount = ids == null ? 0 : ids.length;
        int daemonThreadCount = threadMXBean.getDaemonThreadCount();
        int peakThreadCount = threadMXBean.getPeakThreadCount();
        long totalStartedThreadCount = threadMXBean.getTotalStartedThreadCount();
        long[] counts = new long[]{threadCount, deadLockThreadCount, daemonThreadCount, peakThreadCount, totalStartedThreadCount};
        this.addMetrics(list, threadMetrics, counts, StandardUnit.Count);
    }
}

