/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListInstanceGroupsResult
implements Serializable {
    private ListWithAutoConstructFlag<InstanceGroup> instanceGroups;
    private String marker;

    public List<InstanceGroup> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new ListWithAutoConstructFlag();
            this.instanceGroups.setAutoConstruct(true);
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroup> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        ListWithAutoConstructFlag instanceGroupsCopy = new ListWithAutoConstructFlag(instanceGroups.size());
        instanceGroupsCopy.addAll(instanceGroups);
        this.instanceGroups = instanceGroupsCopy;
    }

    public ListInstanceGroupsResult withInstanceGroups(InstanceGroup ... instanceGroups) {
        if (this.getInstanceGroups() == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroup>(instanceGroups.length));
        }
        for (InstanceGroup value : instanceGroups) {
            this.getInstanceGroups().add(value);
        }
        return this;
    }

    public ListInstanceGroupsResult withInstanceGroups(Collection<InstanceGroup> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
        } else {
            ListWithAutoConstructFlag instanceGroupsCopy = new ListWithAutoConstructFlag(instanceGroups.size());
            instanceGroupsCopy.addAll(instanceGroups);
            this.instanceGroups = instanceGroupsCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListInstanceGroupsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: " + this.getInstanceGroups() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : this.getInstanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceGroupsResult)) {
            return false;
        }
        ListInstanceGroupsResult other = (ListInstanceGroupsResult)obj;
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        if (other.getInstanceGroups() != null && !other.getInstanceGroups().equals(this.getInstanceGroups())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

