/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyNetworkInterfaceAttributeRequestMarshaller
implements Marshaller<Request<ModifyNetworkInterfaceAttributeRequest>, ModifyNetworkInterfaceAttributeRequest> {
    @Override
    public Request<ModifyNetworkInterfaceAttributeRequest> marshall(ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) {
        if (modifyNetworkInterfaceAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyNetworkInterfaceAttributeRequest> request = new DefaultRequest<ModifyNetworkInterfaceAttributeRequest>(modifyNetworkInterfaceAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyNetworkInterfaceAttribute");
        request.addParameter("Version", "2014-05-01");
        if (modifyNetworkInterfaceAttributeRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(modifyNetworkInterfaceAttributeRequest.getNetworkInterfaceId()));
        }
        if (modifyNetworkInterfaceAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString(modifyNetworkInterfaceAttributeRequest.getDescription()));
        }
        if (modifyNetworkInterfaceAttributeRequest.isSourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean(modifyNetworkInterfaceAttributeRequest.isSourceDestCheck()));
        }
        List<String> groupsList = modifyNetworkInterfaceAttributeRequest.getGroups();
        int groupsListIndex = 1;
        for (String groupsListValue : groupsList) {
            if (groupsListValue != null) {
                request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString(groupsListValue));
            }
            ++groupsListIndex;
        }
        NetworkInterfaceAttachmentChanges networkInterfaceAttachmentChangesAttachment = modifyNetworkInterfaceAttributeRequest.getAttachment();
        if (networkInterfaceAttachmentChangesAttachment != null) {
            if (networkInterfaceAttachmentChangesAttachment.getAttachmentId() != null) {
                request.addParameter("Attachment.AttachmentId", StringUtils.fromString(networkInterfaceAttachmentChangesAttachment.getAttachmentId()));
            }
            if (networkInterfaceAttachmentChangesAttachment.isDeleteOnTermination() != null) {
                request.addParameter("Attachment.DeleteOnTermination", StringUtils.fromBoolean(networkInterfaceAttachmentChangesAttachment.isDeleteOnTermination()));
            }
        }
        return request;
    }
}

