/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.profile.internal.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilesConfigFileParser {
    private static final String AWS_ACCESS_KEY_ID = "aws_access_key_id";
    private static final String AWS_SECRET_ACCESS_KEY = "aws_secret_access_key";
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFileParser.class);

    public static Map<String, Profile> loadProfiles(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file is null.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("AWS profiles config file not found in the given path: " + file.getAbsolutePath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Map<String, Profile> map = ProfilesConfigFileParser.loadProfiles(fis);
            return map;
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to load AWS profiles config file at: " + file.getAbsolutePath(), ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Profile> loadProfiles(InputStream is) throws IOException {
        Scanner scanner = new Scanner(is);
        BasicAWSCredentials credentials = null;
        String profileName = null;
        String accessKey = null;
        String secretKey = null;
        String line = null;
        boolean accessKeyRead = false;
        boolean secretKeyRead = false;
        ProfileCredentialScannerState scannerState = ProfileCredentialScannerState.READ_CONFIG_NAME;
        HashMap<String, Profile> profilesByName = new HashMap<String, Profile>();
        try {
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if ((line = line.trim()).isEmpty()) continue;
                if (!(line.startsWith("[") || line.startsWith(AWS_ACCESS_KEY_ID) || line.startsWith(AWS_SECRET_ACCESS_KEY))) {
                    LOG.info((Object)("Unsupported configuration setting: " + line));
                    continue;
                }
                switch (scannerState) {
                    case READ_CONFIG_NAME: {
                        profileName = ProfilesConfigFileParser.parseProfileName(line);
                        scannerState = ProfileCredentialScannerState.READ_KEY;
                        break;
                    }
                    case READ_KEY: {
                        if (line.startsWith(AWS_ACCESS_KEY_ID) && !accessKeyRead) {
                            accessKey = ProfilesConfigFileParser.parseAccessKey(line);
                            accessKeyRead = true;
                            break;
                        }
                        if (!secretKeyRead) {
                            secretKey = ProfilesConfigFileParser.parseSecretKey(line);
                            secretKeyRead = true;
                            break;
                        }
                        throw new AmazonClientException("Unable to load Amazon AWS Credentials. File not in proper format.");
                    }
                }
                if (!accessKeyRead || !secretKeyRead) continue;
                ProfilesConfigFileParser.assertParameterNotEmpty(profileName, "Unable to load credentials into profile. ProfileName is empty. " + line);
                ProfilesConfigFileParser.assertParameterNotEmpty(accessKey, "Unable to load credentials into profile. AWS Access Key ID is empty. " + line);
                ProfilesConfigFileParser.assertParameterNotEmpty(secretKey, "Unable to load credentials into profile. AWS Secret Access Key is empty. " + line);
                credentials = new BasicAWSCredentials(accessKey, secretKey);
                profilesByName.put(profileName, new Profile(credentials));
                scannerState = ProfileCredentialScannerState.READ_CONFIG_NAME;
                accessKeyRead = false;
                secretKeyRead = false;
            }
            if (scannerState != ProfileCredentialScannerState.READ_CONFIG_NAME || accessKeyRead || secretKeyRead) {
                throw new AmazonClientException("Unable to load credentials into profile. Profile Name or AWS Access Key ID or AWS Secret Access Key missing for a profile.");
            }
        }
        finally {
            scanner.close();
        }
        return profilesByName;
    }

    private static String parseProfileName(String line) {
        if (line.startsWith("[") && line.endsWith("]")) {
            String profileName = line.substring(1, line.length() - 1);
            if (profileName.trim().equals("default")) {
                return "default";
            }
            int separatorIndex = profileName.indexOf(" ");
            if (separatorIndex != -1) {
                return profileName.substring(separatorIndex).trim();
            }
        }
        throw new AmazonClientException("Unable to load AWS profiles: Profile name not in proper format: " + line);
    }

    private static String parseAccessKey(String line) {
        if (line.startsWith(AWS_ACCESS_KEY_ID) && line.indexOf("=") != -1) {
            return line.substring(line.indexOf("=") + 1).trim();
        }
        throw new AmazonClientException("Unable to load AWS profiles: AWS Access Key ID not in proper format: " + line);
    }

    private static String parseSecretKey(String line) {
        if (line.startsWith(AWS_SECRET_ACCESS_KEY) && line.indexOf("=") != -1) {
            return line.substring(line.indexOf("=") + 1).trim();
        }
        throw new AmazonClientException("Unable to load AWS profiles: AWS Secret Access Key not in proper format: " + line);
    }

    private static void assertParameterNotEmpty(String parameterValue, String errorMessage) {
        if (parameterValue.isEmpty()) {
            throw new AmazonClientException(errorMessage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProfileCredentialScannerState {
        READ_CONFIG_NAME,
        READ_KEY;

    }
}

