/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateItemRequestMarshaller
implements Marshaller<Request<UpdateItemRequest>, UpdateItemRequest> {
    @Override
    public Request<UpdateItemRequest> marshall(UpdateItemRequest updateItemRequest) {
        if (updateItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateItemRequest> request = new DefaultRequest<UpdateItemRequest>(updateItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.UpdateItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag bSList;
            Object nSListValue;
            Object nSList;
            Object sSListValue3;
            ListWithAutoConstructFlag sSList;
            AttributeValue value;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(updateItemRequest.getTableName());
            }
            if (updateItemRequest.getKey() != null) {
                jsonWriter.key("Key");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> keyListValue : updateItemRequest.getKey().entrySet()) {
                    Object bSList2;
                    Object nSListValue2;
                    ListWithAutoConstructFlag nSList2;
                    ListWithAutoConstructFlag sSList2;
                    if (keyListValue.getValue() == null) continue;
                    jsonWriter.key(keyListValue.getKey());
                    jsonWriter.object();
                    if (keyListValue.getValue().getS() != null) {
                        jsonWriter.key("S").value(keyListValue.getValue().getS());
                    }
                    if (keyListValue.getValue().getN() != null) {
                        jsonWriter.key("N").value(keyListValue.getValue().getN());
                    }
                    if (keyListValue.getValue().getB() != null) {
                        jsonWriter.key("B").value(keyListValue.getValue().getB());
                    }
                    if (!((sSList2 = (ListWithAutoConstructFlag)keyListValue.getValue().getSS()) == null || sSList2.isAutoConstruct() && sSList2.isEmpty())) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (Object sSListValue2 : sSList2) {
                            if (sSListValue2 == null) continue;
                            jsonWriter.value(sSListValue2);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((nSList2 = (ListWithAutoConstructFlag)keyListValue.getValue().getNS()) == null || nSList2.isAutoConstruct() && nSList2.isEmpty())) {
                        Object sSListValue2;
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        sSListValue2 = nSList2.iterator();
                        while (sSListValue2.hasNext()) {
                            nSListValue2 = (String)sSListValue2.next();
                            if (nSListValue2 == null) continue;
                            jsonWriter.value(nSListValue2);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((bSList2 = (ListWithAutoConstructFlag)keyListValue.getValue().getBS()) == null || ((ListWithAutoConstructFlag)bSList2).isAutoConstruct() && ((ArrayList)bSList2).isEmpty())) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        nSListValue2 = ((ArrayList)bSList2).iterator();
                        while (nSListValue2.hasNext()) {
                            ByteBuffer bSListValue = (ByteBuffer)nSListValue2.next();
                            if (bSListValue == null) continue;
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getAttributeUpdates() != null) {
                jsonWriter.key("AttributeUpdates");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValueUpdate> attributeUpdatesListValue : updateItemRequest.getAttributeUpdates().entrySet()) {
                    if (attributeUpdatesListValue.getValue() == null) continue;
                    jsonWriter.key(attributeUpdatesListValue.getKey());
                    jsonWriter.object();
                    value = attributeUpdatesListValue.getValue().getValue();
                    if (value != null) {
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if (!((sSList = (ListWithAutoConstructFlag)value.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            for (Object sSListValue3 : sSList) {
                                if (sSListValue3 == null) continue;
                                jsonWriter.value(sSListValue3);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((nSList = (ListWithAutoConstructFlag)value.getNS()) == null || ((ListWithAutoConstructFlag)nSList).isAutoConstruct() && ((ArrayList)nSList).isEmpty())) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            sSListValue3 = ((ArrayList)nSList).iterator();
                            while (sSListValue3.hasNext()) {
                                nSListValue = (String)sSListValue3.next();
                                if (nSListValue == null) continue;
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((bSList = (ListWithAutoConstructFlag)value.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (attributeUpdatesListValue.getValue().getAction() != null) {
                        jsonWriter.key("Action").value(attributeUpdatesListValue.getValue().getAction());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getExpected() != null) {
                jsonWriter.key("Expected");
                jsonWriter.object();
                for (Map.Entry<String, ExpectedAttributeValue> expectedListValue : updateItemRequest.getExpected().entrySet()) {
                    if (expectedListValue.getValue() == null) continue;
                    jsonWriter.key(expectedListValue.getKey());
                    jsonWriter.object();
                    value = expectedListValue.getValue().getValue();
                    if (value != null) {
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if (!((sSList = (ListWithAutoConstructFlag)value.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            nSList = sSList.iterator();
                            while (nSList.hasNext()) {
                                sSListValue3 = (String)nSList.next();
                                if (sSListValue3 == null) continue;
                                jsonWriter.value(sSListValue3);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((nSList = (ListWithAutoConstructFlag)value.getNS()) == null || ((ListWithAutoConstructFlag)nSList).isAutoConstruct() && ((ArrayList)nSList).isEmpty())) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            sSListValue3 = ((ArrayList)nSList).iterator();
                            while (sSListValue3.hasNext()) {
                                nSListValue = (String)sSListValue3.next();
                                if (nSListValue == null) continue;
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((bSList = (ListWithAutoConstructFlag)value.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (expectedListValue.getValue().isExists() != null) {
                        jsonWriter.key("Exists").value(expectedListValue.getValue().isExists());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value(updateItemRequest.getReturnValues());
            }
            if (updateItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(updateItemRequest.getReturnConsumedCapacity());
            }
            if (updateItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.key("ReturnItemCollectionMetrics").value(updateItemRequest.getReturnItemCollectionMetrics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

