/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunJobFlowRequestMarshaller
implements Marshaller<Request<RunJobFlowRequest>, RunJobFlowRequest> {
    @Override
    public Request<RunJobFlowRequest> marshall(RunJobFlowRequest runJobFlowRequest) {
        if (runJobFlowRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RunJobFlowRequest> request = new DefaultRequest<RunJobFlowRequest>(runJobFlowRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.RunJobFlow";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag tagsList;
            ListWithAutoConstructFlag newSupportedProductsList;
            ListWithAutoConstructFlag supportedProductsList;
            ListWithAutoConstructFlag bootstrapActionsList;
            ListWithAutoConstructFlag argsList;
            ListWithAutoConstructFlag stepsList;
            JobFlowInstancesConfig instances;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (runJobFlowRequest.getName() != null) {
                jsonWriter.key("Name").value(runJobFlowRequest.getName());
            }
            if (runJobFlowRequest.getLogUri() != null) {
                jsonWriter.key("LogUri").value(runJobFlowRequest.getLogUri());
            }
            if (runJobFlowRequest.getAdditionalInfo() != null) {
                jsonWriter.key("AdditionalInfo").value(runJobFlowRequest.getAdditionalInfo());
            }
            if (runJobFlowRequest.getAmiVersion() != null) {
                jsonWriter.key("AmiVersion").value(runJobFlowRequest.getAmiVersion());
            }
            if ((instances = runJobFlowRequest.getInstances()) != null) {
                Object placement;
                ListWithAutoConstructFlag instanceGroupsList;
                jsonWriter.key("Instances");
                jsonWriter.object();
                if (instances.getMasterInstanceType() != null) {
                    jsonWriter.key("MasterInstanceType").value(instances.getMasterInstanceType());
                }
                if (instances.getSlaveInstanceType() != null) {
                    jsonWriter.key("SlaveInstanceType").value(instances.getSlaveInstanceType());
                }
                if (instances.getInstanceCount() != null) {
                    jsonWriter.key("InstanceCount").value(instances.getInstanceCount());
                }
                if (!((instanceGroupsList = (ListWithAutoConstructFlag)instances.getInstanceGroups()) == null || instanceGroupsList.isAutoConstruct() && instanceGroupsList.isEmpty())) {
                    jsonWriter.key("InstanceGroups");
                    jsonWriter.array();
                    for (InstanceGroupConfig instanceGroupsListValue : instanceGroupsList) {
                        if (instanceGroupsListValue == null) continue;
                        jsonWriter.object();
                        if (instanceGroupsListValue.getName() != null) {
                            jsonWriter.key("Name").value(instanceGroupsListValue.getName());
                        }
                        if (instanceGroupsListValue.getMarket() != null) {
                            jsonWriter.key("Market").value(instanceGroupsListValue.getMarket());
                        }
                        if (instanceGroupsListValue.getInstanceRole() != null) {
                            jsonWriter.key("InstanceRole").value(instanceGroupsListValue.getInstanceRole());
                        }
                        if (instanceGroupsListValue.getBidPrice() != null) {
                            jsonWriter.key("BidPrice").value(instanceGroupsListValue.getBidPrice());
                        }
                        if (instanceGroupsListValue.getInstanceType() != null) {
                            jsonWriter.key("InstanceType").value(instanceGroupsListValue.getInstanceType());
                        }
                        if (instanceGroupsListValue.getInstanceCount() != null) {
                            jsonWriter.key("InstanceCount").value(instanceGroupsListValue.getInstanceCount());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if (instances.getEc2KeyName() != null) {
                    jsonWriter.key("Ec2KeyName").value(instances.getEc2KeyName());
                }
                if ((placement = instances.getPlacement()) != null) {
                    jsonWriter.key("Placement");
                    jsonWriter.object();
                    if (((PlacementType)placement).getAvailabilityZone() != null) {
                        jsonWriter.key("AvailabilityZone").value(((PlacementType)placement).getAvailabilityZone());
                    }
                    jsonWriter.endObject();
                }
                if (instances.isKeepJobFlowAliveWhenNoSteps() != null) {
                    jsonWriter.key("KeepJobFlowAliveWhenNoSteps").value(instances.isKeepJobFlowAliveWhenNoSteps());
                }
                if (instances.isTerminationProtected() != null) {
                    jsonWriter.key("TerminationProtected").value(instances.isTerminationProtected());
                }
                if (instances.getHadoopVersion() != null) {
                    jsonWriter.key("HadoopVersion").value(instances.getHadoopVersion());
                }
                if (instances.getEc2SubnetId() != null) {
                    jsonWriter.key("Ec2SubnetId").value(instances.getEc2SubnetId());
                }
                jsonWriter.endObject();
            }
            if (!((stepsList = (ListWithAutoConstructFlag)runJobFlowRequest.getSteps()) == null || stepsList.isAutoConstruct() && stepsList.isEmpty())) {
                jsonWriter.key("Steps");
                jsonWriter.array();
                for (Object stepsListValue : stepsList) {
                    HadoopJarStepConfig hadoopJarStep;
                    if (stepsListValue == null) continue;
                    jsonWriter.object();
                    if (((StepConfig)stepsListValue).getName() != null) {
                        jsonWriter.key("Name").value(((StepConfig)stepsListValue).getName());
                    }
                    if (((StepConfig)stepsListValue).getActionOnFailure() != null) {
                        jsonWriter.key("ActionOnFailure").value(((StepConfig)stepsListValue).getActionOnFailure());
                    }
                    if ((hadoopJarStep = ((StepConfig)stepsListValue).getHadoopJarStep()) != null) {
                        jsonWriter.key("HadoopJarStep");
                        jsonWriter.object();
                        ListWithAutoConstructFlag propertiesList = (ListWithAutoConstructFlag)hadoopJarStep.getProperties();
                        if (!(propertiesList == null || propertiesList.isAutoConstruct() && propertiesList.isEmpty())) {
                            jsonWriter.key("Properties");
                            jsonWriter.array();
                            for (Object propertiesListValue : propertiesList) {
                                if (propertiesListValue == null) continue;
                                jsonWriter.object();
                                if (((KeyValue)propertiesListValue).getKey() != null) {
                                    jsonWriter.key("Key").value(((KeyValue)propertiesListValue).getKey());
                                }
                                if (((KeyValue)propertiesListValue).getValue() != null) {
                                    jsonWriter.key("Value").value(((KeyValue)propertiesListValue).getValue());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        if (hadoopJarStep.getJar() != null) {
                            jsonWriter.key("Jar").value(hadoopJarStep.getJar());
                        }
                        if (hadoopJarStep.getMainClass() != null) {
                            jsonWriter.key("MainClass").value(hadoopJarStep.getMainClass());
                        }
                        if (!((argsList = (ListWithAutoConstructFlag)hadoopJarStep.getArgs()) == null || argsList.isAutoConstruct() && argsList.isEmpty())) {
                            Object propertiesListValue;
                            jsonWriter.key("Args");
                            jsonWriter.array();
                            propertiesListValue = argsList.iterator();
                            while (propertiesListValue.hasNext()) {
                                String argsListValue = (String)propertiesListValue.next();
                                if (argsListValue == null) continue;
                                jsonWriter.value(argsListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((bootstrapActionsList = (ListWithAutoConstructFlag)runJobFlowRequest.getBootstrapActions()) == null || bootstrapActionsList.isAutoConstruct() && bootstrapActionsList.isEmpty())) {
                jsonWriter.key("BootstrapActions");
                jsonWriter.array();
                for (Object bootstrapActionsListValue : bootstrapActionsList) {
                    ScriptBootstrapActionConfig scriptBootstrapAction;
                    if (bootstrapActionsListValue == null) continue;
                    jsonWriter.object();
                    if (((BootstrapActionConfig)bootstrapActionsListValue).getName() != null) {
                        jsonWriter.key("Name").value(((BootstrapActionConfig)bootstrapActionsListValue).getName());
                    }
                    if ((scriptBootstrapAction = ((BootstrapActionConfig)bootstrapActionsListValue).getScriptBootstrapAction()) != null) {
                        jsonWriter.key("ScriptBootstrapAction");
                        jsonWriter.object();
                        if (scriptBootstrapAction.getPath() != null) {
                            jsonWriter.key("Path").value(scriptBootstrapAction.getPath());
                        }
                        if (!((argsList = (ListWithAutoConstructFlag)scriptBootstrapAction.getArgs()) == null || argsList.isAutoConstruct() && argsList.isEmpty())) {
                            jsonWriter.key("Args");
                            jsonWriter.array();
                            for (String argsListValue : argsList) {
                                if (argsListValue == null) continue;
                                jsonWriter.value(argsListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((supportedProductsList = (ListWithAutoConstructFlag)runJobFlowRequest.getSupportedProducts()) == null || supportedProductsList.isAutoConstruct() && supportedProductsList.isEmpty())) {
                jsonWriter.key("SupportedProducts");
                jsonWriter.array();
                for (Object supportedProductsListValue : supportedProductsList) {
                    if (supportedProductsListValue == null) continue;
                    jsonWriter.value(supportedProductsListValue);
                }
                jsonWriter.endArray();
            }
            if (!((newSupportedProductsList = (ListWithAutoConstructFlag)runJobFlowRequest.getNewSupportedProducts()) == null || newSupportedProductsList.isAutoConstruct() && newSupportedProductsList.isEmpty())) {
                jsonWriter.key("NewSupportedProducts");
                jsonWriter.array();
                for (Object newSupportedProductsListValue : newSupportedProductsList) {
                    ListWithAutoConstructFlag argsList2;
                    if (newSupportedProductsListValue == null) continue;
                    jsonWriter.object();
                    if (((SupportedProductConfig)newSupportedProductsListValue).getName() != null) {
                        jsonWriter.key("Name").value(((SupportedProductConfig)newSupportedProductsListValue).getName());
                    }
                    if (!((argsList2 = (ListWithAutoConstructFlag)((SupportedProductConfig)newSupportedProductsListValue).getArgs()) == null || argsList2.isAutoConstruct() && argsList2.isEmpty())) {
                        jsonWriter.key("Args");
                        jsonWriter.array();
                        for (String argsListValue : argsList2) {
                            if (argsListValue == null) continue;
                            jsonWriter.value(argsListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (runJobFlowRequest.isVisibleToAllUsers() != null) {
                jsonWriter.key("VisibleToAllUsers").value(runJobFlowRequest.isVisibleToAllUsers());
            }
            if (runJobFlowRequest.getJobFlowRole() != null) {
                jsonWriter.key("JobFlowRole").value(runJobFlowRequest.getJobFlowRole());
            }
            if (!((tagsList = (ListWithAutoConstructFlag)runJobFlowRequest.getTags()) == null || tagsList.isAutoConstruct() && tagsList.isEmpty())) {
                jsonWriter.key("Tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    jsonWriter.object();
                    if (tagsListValue.getKey() != null) {
                        jsonWriter.key("Key").value(tagsListValue.getKey());
                    }
                    if (tagsListValue.getValue() != null) {
                        jsonWriter.key("Value").value(tagsListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

