/*
 * Copyright 2010-2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.identitymanagement.model;

import java.io.Serializable;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * Container for the parameters to the {@link com.amazonaws.services.identitymanagement.AmazonIdentityManagement#createSAMLProvider(CreateSAMLProviderRequest) CreateSAMLProvider operation}.
 * <p>
 * Creates an IAM entity to describe an identity provider (IdP) that
 * supports SAML 2.0.
 * </p>
 * <p>
 * The SAML provider that you create with this operation can be used as a
 * principal in a role's trust policy to establish a trust relationship
 * between AWS and a SAML identity provider. You can create an IAM role
 * that supports Web-based single sign-on (SSO) to the AWS Management
 * Console or one that supports API access to AWS.
 * </p>
 * <p>
 * When you create the SAML provider, you upload an a SAML metadata
 * document that you get from your IdP and that includes the issuer's
 * name, expiration information, and keys that can be used to validate
 * the SAML authentication response (assertions) that are received from
 * the IdP. You must generate the metadata document using the identity
 * management software that is used as your organization's IdP.
 * </p>
 * <p>
 * <b>NOTE:</b>This operation requires Signature Version 4.
 * </p>
 * <p>
 * For more information, see
 * <a href="http://aws-docs-alpha.integ.amazon.com/STS/latest/UsingSTS/STSMgmtConsole-SAML.html"> Giving Console Access Using SAML </a> and <a href="http://aws-docs-alpha.integ.amazon.com/STS/latest/UsingSTS/CreatingSAML.html"> Creating Temporary Security Credentials for SAML Federation </a>
 * in the <i>Using Temporary Credentials</i> guide.
 * </p>
 *
 * @see com.amazonaws.services.identitymanagement.AmazonIdentityManagement#createSAMLProvider(CreateSAMLProviderRequest)
 */
public class CreateSAMLProviderRequest extends AmazonWebServiceRequest implements Serializable {

    /**
     * An XML document generated by an identity provider (IdP) that supports
     * SAML 2.0. The document includes the issuer's name, expiration
     * information, and keys that can be used to validate the SAML
     * authentication response (assertions) that are received from the IdP.
     * You must generate the metadata document using the identity management
     * software that is used as your organization's IdP. <p>For more
     * information, see <a
     * href="http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSAML.html">Creating
     * Temporary Security Credentials for SAML Federation</a> in the <i>Using
     * Temporary Security Credentials</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1000 - 10000000<br/>
     */
    private String sAMLMetadataDocument;

    /**
     * The name of the provider to create.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[\w._-]*<br/>
     */
    private String name;

    /**
     * An XML document generated by an identity provider (IdP) that supports
     * SAML 2.0. The document includes the issuer's name, expiration
     * information, and keys that can be used to validate the SAML
     * authentication response (assertions) that are received from the IdP.
     * You must generate the metadata document using the identity management
     * software that is used as your organization's IdP. <p>For more
     * information, see <a
     * href="http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSAML.html">Creating
     * Temporary Security Credentials for SAML Federation</a> in the <i>Using
     * Temporary Security Credentials</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1000 - 10000000<br/>
     *
     * @return An XML document generated by an identity provider (IdP) that supports
     *         SAML 2.0. The document includes the issuer's name, expiration
     *         information, and keys that can be used to validate the SAML
     *         authentication response (assertions) that are received from the IdP.
     *         You must generate the metadata document using the identity management
     *         software that is used as your organization's IdP. <p>For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSAML.html">Creating
     *         Temporary Security Credentials for SAML Federation</a> in the <i>Using
     *         Temporary Security Credentials</i> guide.
     */
    public String getSAMLMetadataDocument() {
        return sAMLMetadataDocument;
    }
    
    /**
     * An XML document generated by an identity provider (IdP) that supports
     * SAML 2.0. The document includes the issuer's name, expiration
     * information, and keys that can be used to validate the SAML
     * authentication response (assertions) that are received from the IdP.
     * You must generate the metadata document using the identity management
     * software that is used as your organization's IdP. <p>For more
     * information, see <a
     * href="http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSAML.html">Creating
     * Temporary Security Credentials for SAML Federation</a> in the <i>Using
     * Temporary Security Credentials</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1000 - 10000000<br/>
     *
     * @param sAMLMetadataDocument An XML document generated by an identity provider (IdP) that supports
     *         SAML 2.0. The document includes the issuer's name, expiration
     *         information, and keys that can be used to validate the SAML
     *         authentication response (assertions) that are received from the IdP.
     *         You must generate the metadata document using the identity management
     *         software that is used as your organization's IdP. <p>For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSAML.html">Creating
     *         Temporary Security Credentials for SAML Federation</a> in the <i>Using
     *         Temporary Security Credentials</i> guide.
     */
    public void setSAMLMetadataDocument(String sAMLMetadataDocument) {
        this.sAMLMetadataDocument = sAMLMetadataDocument;
    }
    
    /**
     * An XML document generated by an identity provider (IdP) that supports
     * SAML 2.0. The document includes the issuer's name, expiration
     * information, and keys that can be used to validate the SAML
     * authentication response (assertions) that are received from the IdP.
     * You must generate the metadata document using the identity management
     * software that is used as your organization's IdP. <p>For more
     * information, see <a
     * href="http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSAML.html">Creating
     * Temporary Security Credentials for SAML Federation</a> in the <i>Using
     * Temporary Security Credentials</i> guide.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1000 - 10000000<br/>
     *
     * @param sAMLMetadataDocument An XML document generated by an identity provider (IdP) that supports
     *         SAML 2.0. The document includes the issuer's name, expiration
     *         information, and keys that can be used to validate the SAML
     *         authentication response (assertions) that are received from the IdP.
     *         You must generate the metadata document using the identity management
     *         software that is used as your organization's IdP. <p>For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSAML.html">Creating
     *         Temporary Security Credentials for SAML Federation</a> in the <i>Using
     *         Temporary Security Credentials</i> guide.
     *
     * @return A reference to this updated object so that method calls can be chained 
     *         together.
     */
    public CreateSAMLProviderRequest withSAMLMetadataDocument(String sAMLMetadataDocument) {
        this.sAMLMetadataDocument = sAMLMetadataDocument;
        return this;
    }

    /**
     * The name of the provider to create.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[\w._-]*<br/>
     *
     * @return The name of the provider to create.
     */
    public String getName() {
        return name;
    }
    
    /**
     * The name of the provider to create.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[\w._-]*<br/>
     *
     * @param name The name of the provider to create.
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * The name of the provider to create.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[\w._-]*<br/>
     *
     * @param name The name of the provider to create.
     *
     * @return A reference to this updated object so that method calls can be chained 
     *         together.
     */
    public CreateSAMLProviderRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSAMLMetadataDocument() != null) sb.append("SAMLMetadataDocument: " + getSAMLMetadataDocument() + ",");
        if (getName() != null) sb.append("Name: " + getName() );
        sb.append("}");
        return sb.toString();
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;
        
        hashCode = prime * hashCode + ((getSAMLMetadataDocument() == null) ? 0 : getSAMLMetadataDocument().hashCode()); 
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode()); 
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;

        if (obj instanceof CreateSAMLProviderRequest == false) return false;
        CreateSAMLProviderRequest other = (CreateSAMLProviderRequest)obj;
        
        if (other.getSAMLMetadataDocument() == null ^ this.getSAMLMetadataDocument() == null) return false;
        if (other.getSAMLMetadataDocument() != null && other.getSAMLMetadataDocument().equals(this.getSAMLMetadataDocument()) == false) return false; 
        if (other.getName() == null ^ this.getName() == null) return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false) return false; 
        return true;
    }
    
}
    