/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericActivityWorker;
import com.amazonaws.services.simpleworkflow.flow.worker.SynchronousActivityTaskPoller;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import java.util.List;

public class SynchronousActivityWorker {
    private final SynchronousActivityTaskPoller poller;
    private final POJOActivityImplementationFactory factory = new POJOActivityImplementationFactory();

    public SynchronousActivityWorker() {
        this.poller = new SynchronousActivityTaskPoller();
        this.poller.setActivityImplementationFactory(this.factory);
    }

    public SynchronousActivityWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        this.poller = new SynchronousActivityTaskPoller(service, domain, taskListToPoll, this.factory);
    }

    public boolean pollAndProcessSingleActivityTask() throws Throwable {
        return this.poller.pollAndProcessSingleTask();
    }

    public void setActivitiesImplementations(Iterable<Object> activitiesImplementations) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        this.factory.setActivitiesImplementations(activitiesImplementations);
    }

    public Iterable<Object> getActivitiesImplementations() {
        return this.factory.getActivitiesImplementations();
    }

    public List<ActivityType> addActivitiesImplementations(Iterable<Object> activitiesImplementations) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return this.factory.addActivitiesImplementations(activitiesImplementations);
    }

    public List<ActivityType> addActivitiesImplementations(Iterable<Object> activitiesImplementations, DataConverter dataConverter) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return this.factory.addActivitiesImplementations(activitiesImplementations, dataConverter);
    }

    public List<ActivityType> addActivitiesImplementation(Object activitiesImplementation) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return this.factory.addActivitiesImplementation(activitiesImplementation);
    }

    public List<ActivityType> addActivitiesImplementation(Object activitiesImplementation, DataConverter converter) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return this.factory.addActivitiesImplementation(activitiesImplementation, converter);
    }

    public Iterable<ActivityType> getActivityTypesToRegister() {
        return this.factory.getActivityTypesToRegister();
    }

    public ActivityImplementation getActivityImplementation(ActivityType activityType) {
        return this.factory.getActivityImplementation(activityType);
    }

    public AmazonSimpleWorkflow getService() {
        return this.poller.getService();
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.poller.setService(service);
    }

    public String getDomain() {
        return this.poller.getDomain();
    }

    public void setDomain(String domain) {
        this.poller.setDomain(domain);
    }

    public String getPollTaskList() {
        return this.poller.getPollTaskList();
    }

    public void setTaskListToPoll(String taskList) {
        this.poller.setTaskListToPoll(taskList);
    }

    public String getIdentity() {
        return this.poller.getIdentity();
    }

    public void setIdentity(String identity) {
        this.poller.setIdentity(identity);
    }

    public ExponentialRetryParameters getReportCompletionRetryParameters() {
        return this.poller.getReportCompletionRetryParameters();
    }

    public void setReportCompletionRetryParameters(ExponentialRetryParameters reportCompletionRetryParameters) {
        this.poller.setReportCompletionRetryParameters(reportCompletionRetryParameters);
    }

    public ExponentialRetryParameters getReportFailureRetryParameters() {
        return this.poller.getReportFailureRetryParameters();
    }

    public void setReportFailureRetryParameters(ExponentialRetryParameters reportFailureRetryParameters) {
        this.poller.setReportFailureRetryParameters(reportFailureRetryParameters);
    }

    public String getTaskListToPoll() {
        return this.poller.getTaskListToPoll();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[poller=" + this.poller + ", factory=" + this.factory + "]";
    }

    public void registerTypesToPoll() throws Exception {
        GenericActivityWorker.registerActivityTypes(this.getService(), this.getDomain(), this.getTaskListToPoll(), this.factory);
    }
}

