/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.ModifyClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyClusterRequestMarshaller
implements Marshaller<Request<ModifyClusterRequest>, ModifyClusterRequest> {
    public Request<ModifyClusterRequest> marshall(ModifyClusterRequest modifyClusterRequest) {
        if (modifyClusterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyClusterRequest, "AmazonRedshift");
        request.addParameter("Action", "ModifyCluster");
        request.addParameter("Version", "2012-12-01");
        if (modifyClusterRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)modifyClusterRequest.getClusterIdentifier()));
        }
        if (modifyClusterRequest.getClusterType() != null) {
            request.addParameter("ClusterType", StringUtils.fromString((String)modifyClusterRequest.getClusterType()));
        }
        if (modifyClusterRequest.getNodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)modifyClusterRequest.getNodeType()));
        }
        if (modifyClusterRequest.getNumberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringUtils.fromInteger((Integer)modifyClusterRequest.getNumberOfNodes()));
        }
        List<String> clusterSecurityGroupsList = modifyClusterRequest.getClusterSecurityGroups();
        int clusterSecurityGroupsListIndex = 1;
        for (String clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
            if (clusterSecurityGroupsListValue != null) {
                request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString((String)clusterSecurityGroupsListValue));
            }
            ++clusterSecurityGroupsListIndex;
        }
        List<String> vpcSecurityGroupIdsList = modifyClusterRequest.getVpcSecurityGroupIds();
        int vpcSecurityGroupIdsListIndex = 1;
        for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
            if (vpcSecurityGroupIdsListValue != null) {
                request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
            }
            ++vpcSecurityGroupIdsListIndex;
        }
        if (modifyClusterRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)modifyClusterRequest.getMasterUserPassword()));
        }
        if (modifyClusterRequest.getClusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString((String)modifyClusterRequest.getClusterParameterGroupName()));
        }
        if (modifyClusterRequest.getAutomatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)modifyClusterRequest.getAutomatedSnapshotRetentionPeriod()));
        }
        if (modifyClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyClusterRequest.getClusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString((String)modifyClusterRequest.getClusterVersion()));
        }
        if (modifyClusterRequest.isAllowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyClusterRequest.isAllowVersionUpgrade()));
        }
        if (modifyClusterRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)modifyClusterRequest.getHsmClientCertificateIdentifier()));
        }
        if (modifyClusterRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)modifyClusterRequest.getHsmConfigurationIdentifier()));
        }
        if (modifyClusterRequest.getNewClusterIdentifier() != null) {
            request.addParameter("NewClusterIdentifier", StringUtils.fromString((String)modifyClusterRequest.getNewClusterIdentifier()));
        }
        return request;
    }
}

