/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Map;

public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)scanRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.Scan";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (scanRequest.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)scanRequest.getTableName());
            }
            if (!((attributesToGetList = (ListWithAutoConstructFlag)scanRequest.getAttributesToGet()) == null || attributesToGetList.isAutoConstruct() && attributesToGetList.isEmpty())) {
                jsonWriter.key("AttributesToGet");
                jsonWriter.array();
                for (String string : attributesToGetList) {
                    if (string == null) continue;
                    jsonWriter.value((Object)string);
                }
                jsonWriter.endArray();
            }
            if (scanRequest.getLimit() != null) {
                jsonWriter.key("Limit").value((Object)scanRequest.getLimit());
            }
            if (scanRequest.getSelect() != null) {
                jsonWriter.key("Select").value((Object)scanRequest.getSelect());
            }
            if (scanRequest.getScanFilter() != null) {
                jsonWriter.key("ScanFilter");
                jsonWriter.object();
                for (Map.Entry<String, Condition> entry : scanRequest.getScanFilter().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    ListWithAutoConstructFlag attributeValueListList = (ListWithAutoConstructFlag)entry.getValue().getAttributeValueList();
                    if (!(attributeValueListList == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            ListWithAutoConstructFlag bSList;
                            ListWithAutoConstructFlag nSList;
                            ListWithAutoConstructFlag sSList;
                            if (attributeValueListListValue == null) continue;
                            jsonWriter.object();
                            if (attributeValueListListValue.getS() != null) {
                                jsonWriter.key("S").value((Object)attributeValueListListValue.getS());
                            }
                            if (attributeValueListListValue.getN() != null) {
                                jsonWriter.key("N").value((Object)attributeValueListListValue.getN());
                            }
                            if (attributeValueListListValue.getB() != null) {
                                jsonWriter.key("B").value(attributeValueListListValue.getB());
                            }
                            if (!((sSList = (ListWithAutoConstructFlag)attributeValueListListValue.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                                jsonWriter.key("SS");
                                jsonWriter.array();
                                for (String sSListValue : sSList) {
                                    if (sSListValue == null) continue;
                                    jsonWriter.value((Object)sSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if (!((nSList = (ListWithAutoConstructFlag)attributeValueListListValue.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                                jsonWriter.key("NS");
                                jsonWriter.array();
                                for (String nSListValue : nSList) {
                                    if (nSListValue == null) continue;
                                    jsonWriter.value((Object)nSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if (!((bSList = (ListWithAutoConstructFlag)attributeValueListListValue.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                                jsonWriter.key("BS");
                                jsonWriter.array();
                                for (ByteBuffer bSListValue : bSList) {
                                    if (bSListValue == null) continue;
                                    jsonWriter.value(bSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (entry.getValue().getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value((Object)entry.getValue().getComparisonOperator());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (scanRequest.getConditionalOperator() != null) {
                jsonWriter.key("ConditionalOperator").value((Object)scanRequest.getConditionalOperator());
            }
            if (scanRequest.getExclusiveStartKey() != null) {
                jsonWriter.key("ExclusiveStartKey");
                jsonWriter.object();
                for (Map.Entry<String, Serializable> entry : scanRequest.getExclusiveStartKey().entrySet()) {
                    ListWithAutoConstructFlag bSList;
                    ListWithAutoConstructFlag nSList;
                    ListWithAutoConstructFlag sSList;
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    if (((AttributeValue)entry.getValue()).getS() != null) {
                        jsonWriter.key("S").value((Object)((AttributeValue)entry.getValue()).getS());
                    }
                    if (((AttributeValue)entry.getValue()).getN() != null) {
                        jsonWriter.key("N").value((Object)((AttributeValue)entry.getValue()).getN());
                    }
                    if (((AttributeValue)entry.getValue()).getB() != null) {
                        jsonWriter.key("B").value(((AttributeValue)entry.getValue()).getB());
                    }
                    if (!((sSList = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList) {
                            if (sSListValue == null) continue;
                            jsonWriter.value((Object)sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((nSList = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList) {
                            if (nSListValue == null) continue;
                            jsonWriter.value((Object)nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((bSList = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList) {
                            if (bSListValue == null) continue;
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (scanRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value((Object)scanRequest.getReturnConsumedCapacity());
            }
            if (scanRequest.getTotalSegments() != null) {
                jsonWriter.key("TotalSegments").value((Object)scanRequest.getTotalSegments());
            }
            if (scanRequest.getSegment() != null) {
                jsonWriter.key("Segment").value((Object)scanRequest.getSegment());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] byArray = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

