/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeAvailabilityZonesRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeAvailabilityZonesRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeAvailabilityZonesRequest> {
    private ListWithAutoConstructFlag<String> zoneNames;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getZoneNames() {
        if (this.zoneNames == null) {
            this.zoneNames = new ListWithAutoConstructFlag();
            this.zoneNames.setAutoConstruct(true);
        }
        return this.zoneNames;
    }

    public void setZoneNames(Collection<String> zoneNames) {
        if (zoneNames == null) {
            this.zoneNames = null;
            return;
        }
        ListWithAutoConstructFlag zoneNamesCopy = new ListWithAutoConstructFlag(zoneNames.size());
        zoneNamesCopy.addAll(zoneNames);
        this.zoneNames = zoneNamesCopy;
    }

    public DescribeAvailabilityZonesRequest withZoneNames(String ... zoneNames) {
        if (this.getZoneNames() == null) {
            this.setZoneNames(new ArrayList<String>(zoneNames.length));
        }
        for (String value : zoneNames) {
            this.getZoneNames().add(value);
        }
        return this;
    }

    public DescribeAvailabilityZonesRequest withZoneNames(Collection<String> zoneNames) {
        if (zoneNames == null) {
            this.zoneNames = null;
        } else {
            ListWithAutoConstructFlag zoneNamesCopy = new ListWithAutoConstructFlag(zoneNames.size());
            zoneNamesCopy.addAll(zoneNames);
            this.zoneNames = zoneNamesCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeAvailabilityZonesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeAvailabilityZonesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeAvailabilityZonesRequest> getDryRunRequest() {
        Request<DescribeAvailabilityZonesRequest> request = new DescribeAvailabilityZonesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getZoneNames() != null) {
            sb.append("ZoneNames: " + this.getZoneNames() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getZoneNames() == null ? 0 : this.getZoneNames().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityZonesRequest)) {
            return false;
        }
        DescribeAvailabilityZonesRequest other = (DescribeAvailabilityZonesRequest)obj;
        if (other.getZoneNames() == null ^ this.getZoneNames() == null) {
            return false;
        }
        if (other.getZoneNames() != null && !other.getZoneNames().equals(this.getZoneNames())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }
}

