/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeVolumeStatusRequestMarshaller
implements Marshaller<Request<DescribeVolumeStatusRequest>, DescribeVolumeStatusRequest> {
    @Override
    public Request<DescribeVolumeStatusRequest> marshall(DescribeVolumeStatusRequest describeVolumeStatusRequest) {
        if (describeVolumeStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVolumeStatusRequest> request = new DefaultRequest<DescribeVolumeStatusRequest>(describeVolumeStatusRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVolumeStatus");
        request.addParameter("Version", "2014-05-01");
        List<String> volumeIdsList = describeVolumeStatusRequest.getVolumeIds();
        int volumeIdsListIndex = 1;
        for (String volumeIdsListValue : volumeIdsList) {
            if (volumeIdsListValue != null) {
                request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString(volumeIdsListValue));
            }
            ++volumeIdsListIndex;
        }
        List<Filter> filtersList = describeVolumeStatusRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describeVolumeStatusRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVolumeStatusRequest.getNextToken()));
        }
        if (describeVolumeStatusRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVolumeStatusRequest.getMaxResults()));
        }
        return request;
    }
}

