/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeVTLDevicesRequestMarshaller
implements Marshaller<Request<DescribeVTLDevicesRequest>, DescribeVTLDevicesRequest> {
    @Override
    public Request<DescribeVTLDevicesRequest> marshall(DescribeVTLDevicesRequest describeVTLDevicesRequest) {
        if (describeVTLDevicesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVTLDevicesRequest> request = new DefaultRequest<DescribeVTLDevicesRequest>(describeVTLDevicesRequest, "AWSStorageGateway");
        String target = "StorageGateway_20130630.DescribeVTLDevices";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag vTLDeviceARNsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeVTLDevicesRequest.getGatewayARN() != null) {
                jsonWriter.key("GatewayARN").value(describeVTLDevicesRequest.getGatewayARN());
            }
            if (!((vTLDeviceARNsList = (ListWithAutoConstructFlag)describeVTLDevicesRequest.getVTLDeviceARNs()) == null || vTLDeviceARNsList.isAutoConstruct() && vTLDeviceARNsList.isEmpty())) {
                jsonWriter.key("VTLDeviceARNs");
                jsonWriter.array();
                for (String vTLDeviceARNsListValue : vTLDeviceARNsList) {
                    if (vTLDeviceARNsListValue == null) continue;
                    jsonWriter.value(vTLDeviceARNsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeVTLDevicesRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(describeVTLDevicesRequest.getMarker());
            }
            if (describeVTLDevicesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeVTLDevicesRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

