/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListJobsByStatusRequestMarshaller
implements Marshaller<Request<ListJobsByStatusRequest>, ListJobsByStatusRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<ListJobsByStatusRequest> marshall(ListJobsByStatusRequest listJobsByStatusRequest) {
        String value;
        String name;
        if (listJobsByStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListJobsByStatusRequest> request = new DefaultRequest<ListJobsByStatusRequest>(listJobsByStatusRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.ListJobsByStatus";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Status")) {
            name = DYNAMIC_QUERY_PARAMS.get("Status");
            String string = value = listJobsByStatusRequest.getStatus() == null ? null : StringUtils.fromString(listJobsByStatusRequest.getStatus());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Status}", listJobsByStatusRequest.getStatus() == null ? "" : StringUtils.fromString(listJobsByStatusRequest.getStatus()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Ascending")) {
            name = DYNAMIC_QUERY_PARAMS.get("Ascending");
            String string = value = listJobsByStatusRequest.getAscending() == null ? null : StringUtils.fromString(listJobsByStatusRequest.getAscending());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Ascending}", listJobsByStatusRequest.getAscending() == null ? "" : StringUtils.fromString(listJobsByStatusRequest.getAscending()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("PageToken")) {
            name = DYNAMIC_QUERY_PARAMS.get("PageToken");
            String string = value = listJobsByStatusRequest.getPageToken() == null ? null : StringUtils.fromString(listJobsByStatusRequest.getPageToken());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{PageToken}", listJobsByStatusRequest.getPageToken() == null ? "" : StringUtils.fromString(listJobsByStatusRequest.getPageToken()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }

    static {
        String path = "2012-09-25/jobsByStatus/{Status}?Ascending={Ascending};PageToken={PageToken}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

