/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

public final class TransferProgress {
    private volatile long bytesTransferred = 0L;
    private volatile long totalBytesToTransfer = -1L;

    public long getBytesTransfered() {
        return this.getBytesTransferred();
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public long getTotalBytesToTransfer() {
        return this.totalBytesToTransfer;
    }

    @Deprecated
    public synchronized double getPercentTransfered() {
        return this.getPercentTransferred();
    }

    public synchronized double getPercentTransferred() {
        if (this.getBytesTransferred() < 0L) {
            return 0.0;
        }
        return (double)this.getBytesTransferred() / (double)this.getTotalBytesToTransfer() * 100.0;
    }

    public synchronized void updateProgress(long bytes) {
        this.bytesTransferred += bytes;
    }

    public void setTotalBytesToTransfer(long totalBytesToTransfer) {
        this.totalBytesToTransfer = totalBytesToTransfer;
    }
}

