/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;

public class DeleteItemRequestMarshaller
implements Marshaller<Request<DeleteItemRequest>, DeleteItemRequest> {
    @Override
    public Request<DeleteItemRequest> marshall(DeleteItemRequest deleteItemRequest) {
        if (deleteItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteItemRequest> request = new DefaultRequest<DeleteItemRequest>(deleteItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.DeleteItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deleteItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(deleteItemRequest.getTableName());
            }
            if (deleteItemRequest.getKey() != null) {
                jsonWriter.key("Key");
                jsonWriter.object();
                for (Map.Entry<String, Serializable> entry : deleteItemRequest.getKey().entrySet()) {
                    ListWithAutoConstructFlag bSList;
                    ListWithAutoConstructFlag nSList;
                    ListWithAutoConstructFlag sSList;
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    if (((AttributeValue)entry.getValue()).getS() != null) {
                        jsonWriter.key("S").value(((AttributeValue)entry.getValue()).getS());
                    }
                    if (((AttributeValue)entry.getValue()).getN() != null) {
                        jsonWriter.key("N").value(((AttributeValue)entry.getValue()).getN());
                    }
                    if (((AttributeValue)entry.getValue()).getB() != null) {
                        jsonWriter.key("B").value(((AttributeValue)entry.getValue()).getB());
                    }
                    if (!((sSList = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList) {
                            if (sSListValue == null) continue;
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((nSList = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList) {
                            if (nSListValue == null) continue;
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((bSList = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList) {
                            if (bSListValue == null) continue;
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (deleteItemRequest.getExpected() != null) {
                jsonWriter.key("Expected");
                jsonWriter.object();
                for (Map.Entry<String, Serializable> entry : deleteItemRequest.getExpected().entrySet()) {
                    ListWithAutoConstructFlag attributeValueListList;
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    AttributeValue value = ((ExpectedAttributeValue)entry.getValue()).getValue();
                    if (value != null) {
                        ListWithAutoConstructFlag bSList;
                        ListWithAutoConstructFlag nSList;
                        ListWithAutoConstructFlag sSList;
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if (!((sSList = (ListWithAutoConstructFlag)value.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            for (String sSListValue : sSList) {
                                if (sSListValue == null) continue;
                                jsonWriter.value(sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((nSList = (ListWithAutoConstructFlag)value.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            for (String nSListValue : nSList) {
                                if (nSListValue == null) continue;
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((bSList = (ListWithAutoConstructFlag)value.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (((ExpectedAttributeValue)entry.getValue()).isExists() != null) {
                        jsonWriter.key("Exists").value(((ExpectedAttributeValue)entry.getValue()).isExists());
                    }
                    if (((ExpectedAttributeValue)entry.getValue()).getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value(((ExpectedAttributeValue)entry.getValue()).getComparisonOperator());
                    }
                    if (!((attributeValueListList = (ListWithAutoConstructFlag)((ExpectedAttributeValue)entry.getValue()).getAttributeValueList()) == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            ListWithAutoConstructFlag bSList;
                            ListWithAutoConstructFlag nSList;
                            ListWithAutoConstructFlag sSList;
                            if (attributeValueListListValue == null) continue;
                            jsonWriter.object();
                            if (attributeValueListListValue.getS() != null) {
                                jsonWriter.key("S").value(attributeValueListListValue.getS());
                            }
                            if (attributeValueListListValue.getN() != null) {
                                jsonWriter.key("N").value(attributeValueListListValue.getN());
                            }
                            if (attributeValueListListValue.getB() != null) {
                                jsonWriter.key("B").value(attributeValueListListValue.getB());
                            }
                            if (!((sSList = (ListWithAutoConstructFlag)attributeValueListListValue.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                                jsonWriter.key("SS");
                                jsonWriter.array();
                                for (String sSListValue : sSList) {
                                    if (sSListValue == null) continue;
                                    jsonWriter.value(sSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if (!((nSList = (ListWithAutoConstructFlag)attributeValueListListValue.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                                jsonWriter.key("NS");
                                jsonWriter.array();
                                for (String nSListValue : nSList) {
                                    if (nSListValue == null) continue;
                                    jsonWriter.value(nSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if (!((bSList = (ListWithAutoConstructFlag)attributeValueListListValue.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                                jsonWriter.key("BS");
                                jsonWriter.array();
                                for (ByteBuffer bSListValue : bSList) {
                                    if (bSListValue == null) continue;
                                    jsonWriter.value(bSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (deleteItemRequest.getConditionalOperator() != null) {
                jsonWriter.key("ConditionalOperator").value(deleteItemRequest.getConditionalOperator());
            }
            if (deleteItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value(deleteItemRequest.getReturnValues());
            }
            if (deleteItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(deleteItemRequest.getReturnConsumedCapacity());
            }
            if (deleteItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.key("ReturnItemCollectionMetrics").value(deleteItemRequest.getReturnItemCollectionMetrics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] byArray = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

