/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.json.JsonSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JsonRowDeserializationSchema
implements DeserializationSchema<Row> {
    private static final long serialVersionUID = -228294330688809195L;
    private final TypeInformation<Row> typeInfo;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private boolean failOnMissingField;

    public JsonRowDeserializationSchema(TypeInformation<Row> typeInfo) {
        Preconditions.checkNotNull(typeInfo, (String)"Type information");
        this.typeInfo = typeInfo;
        if (!(typeInfo instanceof RowTypeInfo)) {
            throw new IllegalArgumentException("Row type information expected.");
        }
    }

    public JsonRowDeserializationSchema(String jsonSchema) {
        this(JsonSchemaConverter.convert(jsonSchema));
    }

    public Row deserialize(byte[] message) throws IOException {
        try {
            JsonNode root = this.objectMapper.readTree(message);
            return this.convertRow(root, (RowTypeInfo)this.typeInfo);
        }
        catch (Throwable t) {
            throw new IOException("Failed to deserialize JSON object.", t);
        }
    }

    public boolean isEndOfStream(Row nextElement) {
        return false;
    }

    public TypeInformation<Row> getProducedType() {
        return this.typeInfo;
    }

    public void setFailOnMissingField(boolean failOnMissingField) {
        this.failOnMissingField = failOnMissingField;
    }

    private Object convert(JsonNode node, TypeInformation<?> info) {
        if (info == Types.VOID || node.isNull()) {
            return null;
        }
        if (info == Types.BOOLEAN) {
            return node.asBoolean();
        }
        if (info == Types.STRING) {
            return node.asText();
        }
        if (info == Types.BIG_DEC) {
            return node.decimalValue();
        }
        if (info == Types.BIG_INT) {
            return node.bigIntegerValue();
        }
        if (info == Types.SQL_DATE) {
            return Date.valueOf(node.asText());
        }
        if (info == Types.SQL_TIME) {
            String time = node.asText();
            if (time.indexOf(90) < 0 || time.indexOf(46) >= 0) {
                throw new IllegalStateException("Invalid time format. Only a time in UTC timezone without milliseconds is supported yet. Format: HH:mm:ss'Z'");
            }
            return Time.valueOf(time.substring(0, time.length() - 1));
        }
        if (info == Types.SQL_TIMESTAMP) {
            String timestamp = node.asText();
            if (timestamp.indexOf(90) < 0) {
                throw new IllegalStateException("Invalid timestamp format. Only a timestamp in UTC timezone is supported yet. Format: yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            }
            return Timestamp.valueOf(timestamp.substring(0, timestamp.length() - 1).replace('T', ' '));
        }
        if (info instanceof RowTypeInfo) {
            return this.convertRow(node, (RowTypeInfo)info);
        }
        if (info instanceof ObjectArrayTypeInfo) {
            return this.convertObjectArray(node, ((ObjectArrayTypeInfo)info).getComponentInfo());
        }
        if (info instanceof BasicArrayTypeInfo) {
            return this.convertObjectArray(node, ((BasicArrayTypeInfo)info).getComponentInfo());
        }
        if (info instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)info).getComponentType() == Types.BYTE) {
            return this.convertByteArray(node);
        }
        try {
            return this.objectMapper.treeToValue((TreeNode)node, info.getTypeClass());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unsupported type information '" + info + "' for node: " + node);
        }
    }

    private Row convertRow(JsonNode node, RowTypeInfo info) {
        String[] names = info.getFieldNames();
        TypeInformation[] types = info.getFieldTypes();
        Row row = new Row(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            JsonNode subNode = node.get(name);
            if (subNode == null) {
                if (this.failOnMissingField) {
                    throw new IllegalStateException("Could not find field with name '" + name + "'.");
                }
                row.setField(i, null);
                continue;
            }
            row.setField(i, this.convert(subNode, types[i]));
        }
        return row;
    }

    private Object convertObjectArray(JsonNode node, TypeInformation<?> elementType) {
        Object[] array = (Object[])Array.newInstance(elementType.getTypeClass(), node.size());
        for (int i = 0; i < node.size(); ++i) {
            array[i] = this.convert(node.get(i), elementType);
        }
        return array;
    }

    private Object convertByteArray(JsonNode node) {
        try {
            return node.binaryValue();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize byte array.", e);
        }
    }
}

