/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.json.JsonSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ContainerNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JsonRowSerializationSchema
implements SerializationSchema<Row> {
    private static final long serialVersionUID = -2885556750743978636L;
    private final TypeInformation<Row> typeInfo;
    private final ObjectMapper mapper = new ObjectMapper();
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss'Z'");
    private SimpleDateFormat timeFormatWithMillis = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
    private SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private transient ObjectNode node;

    public JsonRowSerializationSchema(TypeInformation<Row> typeInfo) {
        Preconditions.checkNotNull(typeInfo, (String)"Type information");
        this.typeInfo = typeInfo;
    }

    public JsonRowSerializationSchema(String jsonSchema) {
        this(JsonSchemaConverter.convert(jsonSchema));
    }

    public byte[] serialize(Row row) {
        if (this.node == null) {
            this.node = this.mapper.createObjectNode();
        }
        try {
            this.convertRow(this.node, (RowTypeInfo)this.typeInfo, row);
            return this.mapper.writeValueAsBytes((Object)this.node);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + row + "'. Make sure that the schema matches the input.", t);
        }
    }

    private ObjectNode convertRow(ObjectNode reuse, RowTypeInfo info, Row row) {
        if (reuse == null) {
            reuse = this.mapper.createObjectNode();
        }
        String[] fieldNames = info.getFieldNames();
        TypeInformation[] fieldTypes = info.getFieldTypes();
        if (row.getArity() != fieldNames.length) {
            throw new IllegalStateException(String.format("Number of elements in the row '%s' is different from number of field names: %d", row, fieldNames.length));
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            JsonNode fieldConverted = this.convert((ContainerNode<?>)reuse, reuse.get(name), (TypeInformation<?>)fieldTypes[i], row.getField(i));
            reuse.set(name, fieldConverted);
        }
        return reuse;
    }

    private JsonNode convert(ContainerNode<?> container, JsonNode reuse, TypeInformation<?> info, Object object) {
        if (info == Types.VOID || object == null) {
            return container.nullNode();
        }
        if (info == Types.BOOLEAN) {
            return container.booleanNode(((Boolean)object).booleanValue());
        }
        if (info == Types.STRING) {
            return container.textNode((String)object);
        }
        if (info == Types.BIG_DEC) {
            if (object instanceof BigDecimal) {
                return container.numberNode((BigDecimal)object);
            }
            return container.numberNode(BigDecimal.valueOf(((Number)object).doubleValue()));
        }
        if (info == Types.BIG_INT) {
            if (object instanceof BigInteger) {
                return container.numberNode((BigInteger)object);
            }
            return container.numberNode(BigInteger.valueOf(((Number)object).longValue()));
        }
        if (info == Types.SQL_DATE) {
            return container.textNode(object.toString());
        }
        if (info == Types.SQL_TIME) {
            Time time = (Time)object;
            if (time.getTime() % 1000L > 0L) {
                return container.textNode(this.timeFormatWithMillis.format(time));
            }
            return container.textNode(this.timeFormat.format(time));
        }
        if (info == Types.SQL_TIMESTAMP) {
            return container.textNode(this.timestampFormat.format((Timestamp)object));
        }
        if (info instanceof RowTypeInfo) {
            if (reuse != null && reuse instanceof ObjectNode) {
                return this.convertRow((ObjectNode)reuse, (RowTypeInfo)info, (Row)object);
            }
            return this.convertRow(null, (RowTypeInfo)info, (Row)object);
        }
        if (info instanceof ObjectArrayTypeInfo) {
            if (reuse != null && reuse instanceof ArrayNode) {
                return this.convertObjectArray((ArrayNode)reuse, ((ObjectArrayTypeInfo)info).getComponentInfo(), (Object[])object);
            }
            return this.convertObjectArray(null, ((ObjectArrayTypeInfo)info).getComponentInfo(), (Object[])object);
        }
        if (info instanceof BasicArrayTypeInfo) {
            if (reuse != null && reuse instanceof ArrayNode) {
                return this.convertObjectArray((ArrayNode)reuse, ((BasicArrayTypeInfo)info).getComponentInfo(), (Object[])object);
            }
            return this.convertObjectArray(null, ((BasicArrayTypeInfo)info).getComponentInfo(), (Object[])object);
        }
        if (info instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)info).getComponentType() == Types.BYTE) {
            return container.binaryNode((byte[])object);
        }
        try {
            return this.mapper.valueToTree(object);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unsupported type information '" + info + "' for object: " + object, e);
        }
    }

    private ArrayNode convertObjectArray(ArrayNode reuse, TypeInformation<?> info, Object[] array) {
        if (reuse == null) {
            reuse = this.mapper.createArrayNode();
        } else {
            reuse.removeAll();
        }
        for (Object object : array) {
            reuse.add(this.convert((ContainerNode<?>)reuse, null, info, object));
        }
        return reuse;
    }
}

