/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.table.descriptors.FormatDescriptorValidator;
import org.apache.flink.table.typeutils.TypeStringUtils;
import org.apache.flink.util.Preconditions;

public class Json
extends FormatDescriptor {
    private Boolean failOnMissingField;
    private Boolean deriveSchema;
    private String jsonSchema;
    private String schema;

    public Json() {
        super("json", 1);
    }

    public Json failOnMissingField(boolean failOnMissingField) {
        this.failOnMissingField = failOnMissingField;
        return this;
    }

    public Json jsonSchema(String jsonSchema) {
        Preconditions.checkNotNull((Object)jsonSchema);
        this.jsonSchema = jsonSchema;
        this.schema = null;
        this.deriveSchema = null;
        return this;
    }

    public Json schema(TypeInformation<?> schemaType) {
        Preconditions.checkNotNull(schemaType);
        this.schema = TypeStringUtils.writeTypeInfo(schemaType);
        this.jsonSchema = null;
        this.deriveSchema = null;
        return this;
    }

    public Json deriveSchema() {
        this.deriveSchema = true;
        this.schema = null;
        this.jsonSchema = null;
        return this;
    }

    public void addFormatProperties(DescriptorProperties properties) {
        if (this.deriveSchema != null) {
            properties.putBoolean(FormatDescriptorValidator.FORMAT_DERIVE_SCHEMA(), this.deriveSchema.booleanValue());
        }
        if (this.jsonSchema != null) {
            properties.putString("format.json-schema", this.jsonSchema);
        }
        if (this.schema != null) {
            properties.putString("format.schema", this.schema);
        }
        if (this.failOnMissingField != null) {
            properties.putBoolean("format.fail-on-missing-field", this.failOnMissingField.booleanValue());
        }
    }
}

