/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.factory;

import com.amazonaws.services.kinesisanalytics.flink.connectors.config.AWSConfigConstants;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.BasicCredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.CredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.DefaultCredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.EnvironmentCredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.ProfileCredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.SystemCredentialProvider;
import java.util.Properties;
import org.apache.commons.lang3.Validate;

public final class CredentialProviderFactory {
    private CredentialProviderFactory() {
    }

    public static CredentialProvider newCredentialProvider(AWSConfigConstants.CredentialProviderType credentialProviderType, Properties awsConfigProps) {
        Validate.notNull((Object)awsConfigProps, (String)"AWS configuration properties cannot be null", (Object[])new Object[0]);
        AWSConfigConstants.CredentialProviderType credentialType = credentialProviderType == null ? AWSConfigConstants.CredentialProviderType.AUTO : credentialProviderType;
        switch (credentialType) {
            case AUTO: {
                return new DefaultCredentialProvider(awsConfigProps);
            }
            case BASIC: {
                return new BasicCredentialProvider(awsConfigProps);
            }
            case PROFILE: {
                return new ProfileCredentialProvider(awsConfigProps);
            }
            case ENV_VARIABLES: {
                return new EnvironmentCredentialProvider(awsConfigProps);
            }
            case SYS_PROPERTIES: {
                return new SystemCredentialProvider(awsConfigProps);
            }
        }
        return new DefaultCredentialProvider(awsConfigProps);
    }
}

