/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.json.JsonRowDeserializationSchema;
import org.apache.flink.formats.json.JsonRowSchemaConverter;
import org.apache.flink.formats.json.JsonRowSerializationSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptorValidator;
import org.apache.flink.table.descriptors.JsonValidator;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.types.Row;

public class JsonRowFormatFactory
implements SerializationSchemaFactory<Row>,
DeserializationSchemaFactory<Row> {
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(FormatDescriptorValidator.FORMAT_TYPE(), "json");
        context.put(FormatDescriptorValidator.FORMAT_PROPERTY_VERSION(), "1");
        return context;
    }

    public boolean supportsSchemaDerivation() {
        return true;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("format.json-schema");
        properties.add("format.schema");
        properties.add("format.fail-on-missing-field");
        properties.add(FormatDescriptorValidator.FORMAT_DERIVE_SCHEMA());
        properties.addAll(SchemaValidator.getSchemaDerivationKeys());
        return properties;
    }

    public DeserializationSchema<Row> createDeserializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = JsonRowFormatFactory.validateAndGetProperties(properties);
        JsonRowDeserializationSchema schema = new JsonRowDeserializationSchema(JsonRowFormatFactory.createTypeInformation(descriptorProperties));
        descriptorProperties.getOptionalBoolean("format.fail-on-missing-field").ifPresent(schema::setFailOnMissingField);
        return schema;
    }

    public SerializationSchema<Row> createSerializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = JsonRowFormatFactory.validateAndGetProperties(properties);
        return new JsonRowSerializationSchema(JsonRowFormatFactory.createTypeInformation(descriptorProperties));
    }

    private static DescriptorProperties validateAndGetProperties(Map<String, String> propertiesMap) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(propertiesMap);
        new JsonValidator().validate(descriptorProperties);
        return descriptorProperties;
    }

    private static TypeInformation<Row> createTypeInformation(DescriptorProperties descriptorProperties) {
        if (descriptorProperties.containsKey("format.schema")) {
            return (RowTypeInfo)descriptorProperties.getType("format.schema");
        }
        if (descriptorProperties.containsKey("format.json-schema")) {
            return JsonRowSchemaConverter.convert(descriptorProperties.getString("format.json-schema"));
        }
        return SchemaValidator.deriveFormatFields((DescriptorProperties)descriptorProperties).toRowType();
    }
}

