/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptorValidator;

public class JsonValidator
extends FormatDescriptorValidator {
    public static final String FORMAT_TYPE_VALUE = "json";
    public static final String FORMAT_SCHEMA = "format.schema";
    public static final String FORMAT_JSON_SCHEMA = "format.json-schema";
    public static final String FORMAT_FAIL_ON_MISSING_FIELD = "format.fail-on-missing-field";

    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        properties.validateBoolean(JsonValidator.FORMAT_DERIVE_SCHEMA(), true);
        boolean deriveSchema = properties.getOptionalBoolean(JsonValidator.FORMAT_DERIVE_SCHEMA()).orElse(false);
        boolean hasSchema = properties.containsKey(FORMAT_SCHEMA);
        boolean hasSchemaString = properties.containsKey(FORMAT_JSON_SCHEMA);
        if (deriveSchema && (hasSchema || hasSchemaString)) {
            throw new ValidationException("Format cannot define a schema and derive from the table's schema at the same time.");
        }
        if (!deriveSchema && hasSchema && hasSchemaString) {
            throw new ValidationException("A definition of both a schema and JSON schema is not allowed.");
        }
        if (!(deriveSchema || hasSchema || hasSchemaString)) {
            throw new ValidationException("A definition of a schema or JSON schema is required.");
        }
        if (hasSchema) {
            properties.validateType(FORMAT_SCHEMA, true, false);
        } else if (hasSchemaString) {
            properties.validateString(FORMAT_JSON_SCHEMA, false, 1);
        }
        properties.validateBoolean(FORMAT_FAIL_ON_MISSING_FIELD, true);
    }
}

