/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.util;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.CredentialProvider;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseClientBuilder;
import java.util.Properties;
import org.apache.commons.lang3.Validate;

public final class AWSUtil {
    private AWSUtil() {
    }

    public static AmazonKinesisFirehose createKinesisFirehoseClientFromConfiguration(Properties configProps, CredentialProvider credentialsProvider) {
        AWSUtil.validateConfiguration(configProps);
        Validate.notNull((Object)credentialsProvider, (String)"Credential Provider cannot be null.", (Object[])new Object[0]);
        AmazonKinesisFirehoseClientBuilder firehoseClientBuilder = (AmazonKinesisFirehoseClientBuilder)AmazonKinesisFirehoseClientBuilder.standard().withCredentials(credentialsProvider.getAwsCredentialsProvider());
        String region = configProps.getProperty("aws.region", null);
        String firehoseEndpoint = configProps.getProperty("aws.kinesis.firehose.endpoint", null);
        String firehoseEndpointSigningRegion = configProps.getProperty("aws.kinesis.firehose.endpoint.signing.region", null);
        firehoseClientBuilder = region != null ? (AmazonKinesisFirehoseClientBuilder)firehoseClientBuilder.withRegion(Regions.fromName(region)) : (AmazonKinesisFirehoseClientBuilder)firehoseClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(firehoseEndpoint, firehoseEndpointSigningRegion));
        return (AmazonKinesisFirehose)firehoseClientBuilder.build();
    }

    public static Properties validateConfiguration(Properties configProps) {
        Validate.notNull((Object)configProps, (String)"Configuration properties cannot be null.", (Object[])new Object[0]);
        if (!configProps.containsKey("aws.region") ^ (configProps.containsKey("aws.kinesis.firehose.endpoint") && configProps.containsKey("aws.kinesis.firehose.endpoint.signing.region"))) {
            throw new IllegalArgumentException("Either AWS region should be specified or AWS Firehose endpoint and endpoint signing region.");
        }
        return configProps;
    }

    public static Properties validateBasicProviderConfiguration(Properties configProps) {
        AWSUtil.validateConfiguration(configProps);
        Validate.isTrue((boolean)configProps.containsKey("aws_access_key_id"), (String)"AWS access key must be specified with credential provider BASIC.", (Object[])new Object[0]);
        Validate.isTrue((boolean)configProps.containsKey("aws_secret_access_key"), (String)"AWS secret key must be specified with credential provider BASIC.", (Object[])new Object[0]);
        return configProps;
    }

    public static boolean containsBasicProperties(Properties configProps) {
        Validate.notNull((Object)configProps);
        return configProps.containsKey("aws_access_key_id") && configProps.containsKey("aws_secret_access_key");
    }

    public static Properties validateProfileProviderConfiguration(Properties configProps) {
        AWSUtil.validateConfiguration(configProps);
        Validate.isTrue((boolean)configProps.containsKey("aws.credentials.provider.profile.name"), (String)"AWS profile name should be specified with credential provider PROFILE.", (Object[])new Object[0]);
        return configProps;
    }
}

