/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class AWSConfigConstants {
    public static final String AWS_ACCESS_KEY_ID = "aws_access_key_id";
    public static final String AWS_SECRET_ACCESS_KEY = "aws_secret_access_key";
    public static final String AWS_REGION = "aws.region";
    public static final String AWS_CREDENTIALS_PROVIDER = "aws.credentials.provider";
    public static final String AWS_KINESIS_FIREHOSE_ENDPOINT = "aws.kinesis.firehose.endpoint";
    public static final String AWS_KINESIS_FIREHOSE_ENDPOINT_SIGNING_REGION = "aws.kinesis.firehose.endpoint.signing.region";
    public static final String AWS_PROFILE_NAME = AWSConfigConstants.profileName("aws.credentials.provider");
    public static final String AWS_PROFILE_PATH = AWSConfigConstants.profilePath("aws.credentials.provider");
    public static final String AWS_ROLE_ARN = AWSConfigConstants.roleArn("aws.credentials.provider");
    public static final String AWS_ROLE_SESSION_NAME = AWSConfigConstants.roleSessionName("aws.credentials.provider");
    public static final String AWS_ROLE_EXTERNAL_ID = AWSConfigConstants.externalId("aws.credentials.provider");
    public static final String AWS_ROLE_CREDENTIALS_PROVIDER = AWSConfigConstants.roleCredentialsProvider("aws.credentials.provider");

    private AWSConfigConstants() {
    }

    @Nonnull
    public static String accessKeyId(@Nullable String prefix) {
        return (!StringUtils.isEmpty((CharSequence)prefix) ? prefix + ".basic." : "") + AWS_ACCESS_KEY_ID;
    }

    @Nonnull
    public static String accessKeyId() {
        return AWSConfigConstants.accessKeyId(null);
    }

    @Nonnull
    public static String secretKey(@Nullable String prefix) {
        return (!StringUtils.isEmpty((CharSequence)prefix) ? prefix + ".basic." : "") + AWS_SECRET_ACCESS_KEY;
    }

    @Nonnull
    public static String secretKey() {
        return AWSConfigConstants.secretKey(null);
    }

    @Nonnull
    public static String profilePath(@Nonnull String prefix) {
        Validate.notBlank((CharSequence)prefix);
        return prefix + ".profile.path";
    }

    @Nonnull
    public static String profileName(@Nonnull String prefix) {
        Validate.notBlank((CharSequence)prefix);
        return prefix + ".profile.name";
    }

    @Nonnull
    public static String roleArn(@Nonnull String prefix) {
        Validate.notBlank((CharSequence)prefix);
        return prefix + ".role.arn";
    }

    @Nonnull
    public static String roleSessionName(@Nonnull String prefix) {
        Validate.notBlank((CharSequence)prefix);
        return prefix + ".role.sessionName";
    }

    @Nonnull
    public static String externalId(@Nonnull String prefix) {
        Validate.notBlank((CharSequence)prefix);
        return prefix + ".role.externalId";
    }

    @Nonnull
    public static String roleCredentialsProvider(@Nonnull String prefix) {
        Validate.notBlank((CharSequence)prefix);
        return prefix + ".role.provider";
    }

    public static enum CredentialProviderType {
        BASIC,
        ENV_VARIABLES,
        SYS_PROPERTIES,
        PROFILE,
        ASSUME_ROLE,
        AUTO;

    }
}

