/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.producer.impl;

import com.amazonaws.services.kinesisanalytics.flink.connectors.config.ProducerConfigConstants;
import com.amazonaws.services.kinesisanalytics.flink.connectors.util.AWSUtil;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class FirehoseProducerConfiguration {
    private final int maxBufferSize;
    private final int maxPutRecordBatchBytes;
    private final long bufferTimeoutInMillis;
    private final long bufferFullWaitTimeoutInMillis;
    private final long bufferTimeoutBetweenFlushes;
    private final int numberOfRetries;
    private final long maxBackOffInMillis;
    private final long baseBackOffInMillis;
    private final long maxOperationTimeoutInMillis;

    private FirehoseProducerConfiguration(@Nonnull Builder builder) {
        this.maxBufferSize = builder.maxBufferSize;
        this.maxPutRecordBatchBytes = builder.maxPutRecordBatchBytes;
        this.bufferTimeoutInMillis = builder.bufferTimeoutInMillis;
        this.bufferFullWaitTimeoutInMillis = builder.bufferFullWaitTimeoutInMillis;
        this.bufferTimeoutBetweenFlushes = builder.bufferTimeoutBetweenFlushes;
        this.numberOfRetries = builder.numberOfRetries;
        this.maxBackOffInMillis = builder.maxBackOffInMillis;
        this.baseBackOffInMillis = builder.baseBackOffInMillis;
        this.maxOperationTimeoutInMillis = builder.maxOperationTimeoutInMillis;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getMaxPutRecordBatchBytes() {
        return this.maxPutRecordBatchBytes;
    }

    public long getBufferTimeoutInMillis() {
        return this.bufferTimeoutInMillis;
    }

    public long getBufferFullWaitTimeoutInMillis() {
        return this.bufferFullWaitTimeoutInMillis;
    }

    public long getBufferTimeoutBetweenFlushes() {
        return this.bufferTimeoutBetweenFlushes;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public long getMaxBackOffInMillis() {
        return this.maxBackOffInMillis;
    }

    public long getBaseBackOffInMillis() {
        return this.baseBackOffInMillis;
    }

    public long getMaxOperationTimeoutInMillis() {
        return this.maxOperationTimeoutInMillis;
    }

    @Nonnull
    public static Builder builder(@Nonnull Properties config) {
        String region = config.getProperty("aws.region");
        return FirehoseProducerConfiguration.builder(region).withProperties(config);
    }

    @Nonnull
    public static Builder builder(@Nullable String region) {
        return new Builder(region);
    }

    public static class Builder {
        private int maxBufferSize = 500;
        private int maxPutRecordBatchBytes;
        private int numberOfRetries = 10;
        private long bufferTimeoutInMillis = ProducerConfigConstants.DEFAULT_MAX_BUFFER_TIMEOUT;
        private long maxOperationTimeoutInMillis = ProducerConfigConstants.DEFAULT_MAX_OPERATION_TIMEOUT;
        private long bufferFullWaitTimeoutInMillis = 100L;
        private long bufferTimeoutBetweenFlushes = 50L;
        private long maxBackOffInMillis = 100L;
        private long baseBackOffInMillis = 10L;

        public Builder(@Nullable String region) {
            this.maxPutRecordBatchBytes = AWSUtil.getDefaultMaxPutRecordBatchBytes(region);
        }

        @Nonnull
        public FirehoseProducerConfiguration build() {
            return new FirehoseProducerConfiguration(this);
        }

        @Nonnull
        public Builder withMaxBufferSize(int maxBufferSize) {
            Validate.isTrue((maxBufferSize > 0 && maxBufferSize <= 500 ? 1 : 0) != 0, (String)String.format("Buffer size must be between 1 and %d", 500), (Object[])new Object[0]);
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        @Nonnull
        public Builder withMaxPutRecordBatchBytes(int maxPutRecordBatchBytes) {
            Validate.isTrue((maxPutRecordBatchBytes > 0 && maxPutRecordBatchBytes <= 0x400000 ? 1 : 0) != 0, (String)String.format("Maximum batch size in bytes must be between 1 and %d", 0x400000), (Object[])new Object[0]);
            this.maxPutRecordBatchBytes = maxPutRecordBatchBytes;
            return this;
        }

        @Nonnull
        public Builder withNumberOfRetries(int numberOfRetries) {
            Validate.isTrue((numberOfRetries >= 0 ? 1 : 0) != 0, (String)"Number of retries cannot be negative.", (Object[])new Object[0]);
            this.numberOfRetries = numberOfRetries;
            return this;
        }

        @Nonnull
        public Builder withBufferTimeoutInMillis(long bufferTimeoutInMillis) {
            Validate.isTrue((bufferTimeoutInMillis >= 0L ? 1 : 0) != 0, (String)"Flush timeout should be greater than 0.", (Object[])new Object[0]);
            this.bufferTimeoutInMillis = bufferTimeoutInMillis;
            return this;
        }

        @Nonnull
        public Builder withMaxOperationTimeoutInMillis(long maxOperationTimeoutInMillis) {
            Validate.isTrue((maxOperationTimeoutInMillis >= 0L ? 1 : 0) != 0, (String)"Max operation timeout should be greater than 0.", (Object[])new Object[0]);
            this.maxOperationTimeoutInMillis = maxOperationTimeoutInMillis;
            return this;
        }

        @Nonnull
        public Builder withBufferFullWaitTimeoutInMillis(long bufferFullWaitTimeoutInMillis) {
            Validate.isTrue((bufferFullWaitTimeoutInMillis >= 0L ? 1 : 0) != 0, (String)"Buffer full waiting timeout should be greater than 0.", (Object[])new Object[0]);
            this.bufferFullWaitTimeoutInMillis = bufferFullWaitTimeoutInMillis;
            return this;
        }

        @Nonnull
        public Builder withBufferTimeoutBetweenFlushes(long bufferTimeoutBetweenFlushes) {
            Validate.isTrue((bufferTimeoutBetweenFlushes >= 0L ? 1 : 0) != 0, (String)"Interval between flushes cannot be negative.", (Object[])new Object[0]);
            this.bufferTimeoutBetweenFlushes = bufferTimeoutBetweenFlushes;
            return this;
        }

        @Nonnull
        public Builder withMaxBackOffInMillis(long maxBackOffInMillis) {
            Validate.isTrue((maxBackOffInMillis >= 0L ? 1 : 0) != 0, (String)"Max backoff timeout should be greater than 0.", (Object[])new Object[0]);
            this.maxBackOffInMillis = maxBackOffInMillis;
            return this;
        }

        @Nonnull
        public Builder withBaseBackOffInMillis(long baseBackOffInMillis) {
            Validate.isTrue((baseBackOffInMillis >= 0L ? 1 : 0) != 0, (String)"Base backoff timeout should be greater than 0.", (Object[])new Object[0]);
            this.baseBackOffInMillis = baseBackOffInMillis;
            return this;
        }

        @Nonnull
        public Builder withProperties(@Nonnull Properties config) {
            Optional.ofNullable(config.getProperty("firehose.producer.batch.size")).map(Integer::parseInt).ifPresent(this::withMaxBufferSize);
            Optional.ofNullable(config.getProperty("firehose.producer.batch.bytes")).map(Integer::parseInt).ifPresent(this::withMaxPutRecordBatchBytes);
            Optional.ofNullable(config.getProperty("firehose.producer.buffer.flush.retries")).map(Integer::parseInt).ifPresent(this::withNumberOfRetries);
            Optional.ofNullable(config.getProperty("firehose.producer.buffer.timeout")).map(Long::parseLong).ifPresent(this::withBufferTimeoutInMillis);
            Optional.ofNullable(config.getProperty("firehose.producer.buffer.full.wait.timeout")).map(Long::parseLong).ifPresent(this::withBufferFullWaitTimeoutInMillis);
            Optional.ofNullable(config.getProperty("firehose.producer.buffer.flush.timeout")).map(Long::parseLong).ifPresent(this::withBufferTimeoutBetweenFlushes);
            Optional.ofNullable(config.getProperty("firehose.producer.buffer.max.backoff")).map(Long::parseLong).ifPresent(this::withMaxBackOffInMillis);
            Optional.ofNullable(config.getProperty("firehose.producer.buffer.base.backoff")).map(Long::parseLong).ifPresent(this::withBaseBackOffInMillis);
            Optional.ofNullable(config.getProperty("firehose.producer.operation.timeout")).map(Long::parseLong).ifPresent(this::withMaxOperationTimeoutInMillis);
            return this;
        }
    }
}

