/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential;

import com.amazonaws.services.kinesisanalytics.flink.connectors.config.AWSConfigConstants;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.CredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.factory.CredentialProviderFactory;
import com.amazonaws.services.kinesisanalytics.flink.connectors.util.AWSUtil;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import java.util.Properties;
import javax.annotation.Nonnull;

public class AssumeRoleCredentialsProvider
extends CredentialProvider {
    public AssumeRoleCredentialsProvider(Properties properties, String providerKey) {
        super(AWSUtil.validateAssumeRoleCredentialsProvider(properties, providerKey), providerKey);
    }

    public AssumeRoleCredentialsProvider(Properties properties) {
        this(properties, "aws.credentials.provider");
    }

    @Override
    public AWSCredentialsProvider getAwsCredentialsProvider() {
        String baseCredentialsProviderKey = AWSConfigConstants.roleCredentialsProvider(this.providerKey);
        AWSConfigConstants.CredentialProviderType baseCredentialsProviderType = AWSUtil.getCredentialProviderType(this.properties, baseCredentialsProviderKey);
        CredentialProvider baseCredentialsProvider = CredentialProviderFactory.newCredentialProvider(baseCredentialsProviderType, this.properties, baseCredentialsProviderKey);
        AWSSecurityTokenService baseCredentials = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(baseCredentialsProvider.getAwsCredentialsProvider())).withRegion(this.properties.getProperty("aws.region"))).build();
        return this.createAwsCredentialsProvider(this.properties.getProperty(AWSConfigConstants.roleArn(this.providerKey)), this.properties.getProperty(AWSConfigConstants.roleSessionName(this.providerKey)), this.properties.getProperty(AWSConfigConstants.externalId(this.providerKey)), baseCredentials);
    }

    AWSCredentialsProvider createAwsCredentialsProvider(@Nonnull String roleArn, @Nonnull String roleSessionName, @Nonnull String externalId, @Nonnull AWSSecurityTokenService securityTokenService) {
        return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, roleSessionName).withExternalId(externalId).withStsClient(securityTokenService).build();
    }
}

