/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential;

import com.amazonaws.services.kinesisanalytics.flink.connectors.config.AWSConfigConstants;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.CredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.util.AWSUtil;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth.BasicAWSCredentials;
import java.util.Properties;

public class BasicCredentialProvider
extends CredentialProvider {
    public BasicCredentialProvider(Properties properties, String providerKey) {
        super(AWSUtil.validateBasicProviderConfiguration(properties, providerKey), providerKey);
    }

    public BasicCredentialProvider(Properties properties) {
        this(properties, null);
    }

    @Override
    public AWSCredentialsProvider getAwsCredentialsProvider() {
        return new AWSCredentialsProvider(){

            @Override
            public AWSCredentials getCredentials() {
                return new BasicAWSCredentials(BasicCredentialProvider.this.properties.getProperty(AWSConfigConstants.accessKeyId(BasicCredentialProvider.this.providerKey)), BasicCredentialProvider.this.properties.getProperty(AWSConfigConstants.secretKey(BasicCredentialProvider.this.providerKey)));
            }

            @Override
            public void refresh() {
            }
        };
    }
}

