/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential;

import com.amazonaws.services.kinesisanalytics.flink.connectors.config.AWSConfigConstants;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.CredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.util.AWSUtil;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth.profile.ProfileCredentialsProvider;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ProfileCredentialProvider
extends CredentialProvider {
    public ProfileCredentialProvider(Properties properties, String providerKey) {
        super(AWSUtil.validateProfileProviderConfiguration(properties, providerKey), providerKey);
    }

    public ProfileCredentialProvider(Properties properties) {
        this(properties, "aws.credentials.provider");
    }

    @Override
    public AWSCredentialsProvider getAwsCredentialsProvider() {
        String profileName = this.properties.getProperty(AWSConfigConstants.profileName(this.providerKey));
        String profilePath = this.properties.getProperty(AWSConfigConstants.profilePath(this.providerKey));
        return StringUtils.isEmpty((CharSequence)profilePath) ? new ProfileCredentialsProvider(profileName) : new ProfileCredentialsProvider(profilePath, profileName);
    }
}

