/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.factory;

import com.amazonaws.services.kinesisanalytics.flink.connectors.config.AWSConfigConstants;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.AssumeRoleCredentialsProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.BasicCredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.CredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.DefaultCredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.EnvironmentCredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.ProfileCredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.SystemCredentialProvider;
import java.util.Properties;
import org.apache.commons.lang3.Validate;

public final class CredentialProviderFactory {
    private CredentialProviderFactory() {
    }

    public static CredentialProvider newCredentialProvider(AWSConfigConstants.CredentialProviderType credentialProviderType, Properties awsConfigProps, String awsConfigCredentialProviderKey) {
        Validate.notNull((Object)awsConfigProps, (String)"AWS configuration properties cannot be null", (Object[])new Object[0]);
        if (credentialProviderType == null) {
            return new DefaultCredentialProvider(awsConfigProps, awsConfigCredentialProviderKey);
        }
        switch (credentialProviderType) {
            case BASIC: {
                if ("aws.credentials.provider".equals(awsConfigCredentialProviderKey) && !awsConfigProps.containsKey("aws.credentials.provider")) {
                    return new BasicCredentialProvider(awsConfigProps, null);
                }
                return new BasicCredentialProvider(awsConfigProps, awsConfigCredentialProviderKey);
            }
            case PROFILE: {
                return new ProfileCredentialProvider(awsConfigProps, awsConfigCredentialProviderKey);
            }
            case ENV_VARIABLES: {
                return new EnvironmentCredentialProvider(awsConfigProps, awsConfigCredentialProviderKey);
            }
            case SYS_PROPERTIES: {
                return new SystemCredentialProvider(awsConfigProps, awsConfigCredentialProviderKey);
            }
            case ASSUME_ROLE: {
                return new AssumeRoleCredentialsProvider(awsConfigProps, awsConfigCredentialProviderKey);
            }
        }
        return new DefaultCredentialProvider(awsConfigProps, awsConfigCredentialProviderKey);
    }

    public static CredentialProvider newCredentialProvider(AWSConfigConstants.CredentialProviderType credentialProviderType, Properties awsConfigProps) {
        return CredentialProviderFactory.newCredentialProvider(credentialProviderType, awsConfigProps, "aws.credentials.provider");
    }
}

