/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.serialization;

import com.amazonaws.services.kinesisanalytics.flink.connectors.exception.SerializationException;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class JsonSerializationSchema<T>
implements SerializationSchema<T> {
    private static final ObjectMapper mapper = new ObjectMapper();

    public byte[] serialize(T element) {
        Validate.notNull(element);
        try {
            return mapper.writeValueAsBytes(element);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Failed trying to serialize", e);
        }
    }
}

