/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.util;

import com.amazonaws.services.kinesisanalytics.flink.connectors.config.AWSConfigConstants;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.CredentialProvider;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseClientBuilder;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class AWSUtil {
    private AWSUtil() {
    }

    public static AmazonKinesisFirehose createKinesisFirehoseClientFromConfiguration(@Nonnull Properties configProps, @Nonnull CredentialProvider credentialsProvider) {
        AWSUtil.validateConfiguration(configProps);
        Validate.notNull((Object)credentialsProvider, (String)"Credential Provider cannot be null.", (Object[])new Object[0]);
        AmazonKinesisFirehoseClientBuilder firehoseClientBuilder = (AmazonKinesisFirehoseClientBuilder)AmazonKinesisFirehoseClientBuilder.standard().withCredentials(credentialsProvider.getAwsCredentialsProvider());
        String region = configProps.getProperty("aws.region", null);
        String firehoseEndpoint = configProps.getProperty("aws.kinesis.firehose.endpoint", null);
        String firehoseEndpointSigningRegion = configProps.getProperty("aws.kinesis.firehose.endpoint.signing.region", null);
        firehoseClientBuilder = region != null ? (AmazonKinesisFirehoseClientBuilder)firehoseClientBuilder.withRegion(Regions.fromName(region)) : (AmazonKinesisFirehoseClientBuilder)firehoseClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(firehoseEndpoint, firehoseEndpointSigningRegion));
        return (AmazonKinesisFirehose)firehoseClientBuilder.build();
    }

    public static Properties validateConfiguration(Properties configProps) {
        Validate.notNull((Object)configProps, (String)"Configuration properties cannot be null.", (Object[])new Object[0]);
        if (!configProps.containsKey("aws.region") ^ (configProps.containsKey("aws.kinesis.firehose.endpoint") && configProps.containsKey("aws.kinesis.firehose.endpoint.signing.region"))) {
            throw new IllegalArgumentException("Either AWS region should be specified or AWS Firehose endpoint and endpoint signing region.");
        }
        return configProps;
    }

    public static Properties validateBasicProviderConfiguration(Properties configProps, String providerKey) {
        AWSUtil.validateConfiguration(configProps);
        Validate.isTrue((boolean)configProps.containsKey(AWSConfigConstants.accessKeyId(providerKey)), (String)"AWS access key must be specified with credential provider BASIC.", (Object[])new Object[0]);
        Validate.isTrue((boolean)configProps.containsKey(AWSConfigConstants.secretKey(providerKey)), (String)"AWS secret key must be specified with credential provider BASIC.", (Object[])new Object[0]);
        return configProps;
    }

    public static Properties validateBasicProviderConfiguration(Properties configProps) {
        return AWSUtil.validateBasicProviderConfiguration(configProps, null);
    }

    public static boolean containsBasicProperties(Properties configProps, String providerKey) {
        Validate.notNull((Object)configProps);
        return configProps.containsKey(AWSConfigConstants.accessKeyId(providerKey)) && configProps.containsKey(AWSConfigConstants.secretKey(providerKey));
    }

    public static AWSConfigConstants.CredentialProviderType getCredentialProviderType(Properties configProps, String providerKey) {
        if (providerKey == null || !configProps.containsKey(providerKey)) {
            return AWSUtil.containsBasicProperties(configProps, providerKey) ? AWSConfigConstants.CredentialProviderType.BASIC : AWSConfigConstants.CredentialProviderType.AUTO;
        }
        String providerTypeString = configProps.getProperty(providerKey);
        if (StringUtils.isEmpty((CharSequence)providerTypeString)) {
            return AWSConfigConstants.CredentialProviderType.AUTO;
        }
        try {
            return AWSConfigConstants.CredentialProviderType.valueOf(providerTypeString);
        }
        catch (IllegalArgumentException e) {
            return AWSConfigConstants.CredentialProviderType.AUTO;
        }
    }

    public static Properties validateProfileProviderConfiguration(Properties configProps, String providerKey) {
        AWSUtil.validateConfiguration(configProps);
        Validate.notBlank((CharSequence)providerKey);
        Validate.isTrue((boolean)configProps.containsKey(AWSConfigConstants.profileName(providerKey)), (String)"AWS profile name should be specified with credential provider PROFILE.", (Object[])new Object[0]);
        return configProps;
    }

    public static Properties validateProfileProviderConfiguration(Properties configProps) {
        return AWSUtil.validateProfileProviderConfiguration(configProps, "aws.credentials.provider");
    }

    public static Properties validateAssumeRoleCredentialsProvider(Properties configProps, String providerKey) {
        AWSUtil.validateConfiguration(configProps);
        Validate.isTrue((boolean)configProps.containsKey(AWSConfigConstants.roleArn(providerKey)), (String)"AWS role arn to be assumed must be provided with credential provider type ASSUME_ROLE", (Object[])new Object[0]);
        Validate.isTrue((boolean)configProps.containsKey(AWSConfigConstants.roleSessionName(providerKey)), (String)"AWS role session name must be provided with credential provider type ASSUME_ROLE", (Object[])new Object[0]);
        return configProps;
    }

    public static Properties validateAssumeRoleCredentialsProvider(Properties configProps) {
        return AWSUtil.validateAssumeRoleCredentialsProvider(configProps, "aws.credentials.provider");
    }

    public static int getDefaultMaxPutRecordBatchBytes(@Nullable String region) {
        if (region != null) {
            switch (region) {
                case "us-east-1": 
                case "us-west-2": 
                case "eu-west-1": {
                    return 0x400000;
                }
            }
        }
        return 0x100000;
    }
}

