/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.AbortedException;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.AmazonServiceException;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.auth.DaemonThreadFactory;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.internal.SdkPredicate;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.util.ValidationUtils;
import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
@SdkInternalApi
class RefreshableTask<T>
implements Closeable {
    private static final long BLOCKING_REFRESH_MAX_WAIT_IN_SECONDS = 5L;
    private final Lock blockingRefreshLock = new ReentrantLock();
    private final AtomicReference<T> refreshableValueHolder = new AtomicReference();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
    private final AtomicBoolean asyncRefreshing = new AtomicBoolean(false);
    private final Callable<T> refreshCallable;
    private final SdkPredicate<T> shouldDoBlockingRefresh;
    private final SdkPredicate<T> shouldDoAsyncRefresh;

    private RefreshableTask(Callable<T> refreshCallable, SdkPredicate<T> shouldDoBlockingRefresh, SdkPredicate<T> shouldDoAsyncRefresh) {
        this.refreshCallable = ValidationUtils.assertNotNull(refreshCallable, "refreshCallable");
        this.shouldDoBlockingRefresh = ValidationUtils.assertNotNull(shouldDoBlockingRefresh, "shouldDoBlockingRefresh");
        this.shouldDoAsyncRefresh = ValidationUtils.assertNotNull(shouldDoAsyncRefresh, "shouldDoAsyncRefresh");
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    public T getValue() throws AmazonClientException, IllegalStateException {
        if (this.shouldDoBlockingRefresh()) {
            this.blockingRefresh();
        } else if (this.shouldDoAsyncRefresh()) {
            this.asyncRefresh();
        }
        return this.getRefreshedValue();
    }

    public T forceGetValue() {
        this.refreshValue();
        return this.getRefreshedValue();
    }

    private T getRefreshedValue() throws IllegalStateException {
        T refreshableValue = this.refreshableValueHolder.get();
        if (refreshableValue != null) {
            return refreshableValue;
        }
        throw new IllegalStateException("Refreshed value should never be null.");
    }

    private boolean shouldDoBlockingRefresh() {
        return this.shouldDoBlockingRefresh.test(this.refreshableValueHolder.get());
    }

    private boolean shouldDoAsyncRefresh() {
        return this.shouldDoAsyncRefresh.test(this.refreshableValueHolder.get());
    }

    private void blockingRefresh() {
        try {
            if (this.blockingRefreshLock.tryLock(5L, TimeUnit.SECONDS)) {
                try {
                    if (!this.shouldDoBlockingRefresh()) {
                        return;
                    }
                    this.refreshValue();
                    return;
                }
                finally {
                    this.blockingRefreshLock.unlock();
                }
            }
        }
        catch (InterruptedException ex) {
            this.handleInterruptedException("Interrupted waiting to refresh the value.", ex);
        }
        this.refreshValue();
    }

    private void asyncRefresh() {
        if (this.asyncRefreshing.compareAndSet(false, true)) {
            try {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RefreshableTask.this.refreshValue();
                        }
                        finally {
                            RefreshableTask.this.asyncRefreshing.set(false);
                        }
                    }
                });
            }
            catch (RuntimeException ex) {
                this.asyncRefreshing.set(false);
                throw ex;
            }
        }
    }

    private void refreshValue() {
        try {
            this.refreshableValueHolder.compareAndSet(this.refreshableValueHolder.get(), this.refreshCallable.call());
        }
        catch (AmazonServiceException ase) {
            throw ase;
        }
        catch (AmazonClientException ace) {
            throw ace;
        }
        catch (Exception e) {
            throw new AmazonClientException(e);
        }
    }

    private void handleInterruptedException(String message, InterruptedException cause) {
        Thread.currentThread().interrupt();
        throw new AbortedException(message, cause);
    }

    @NotThreadSafe
    public static class Builder<T> {
        private Callable<T> refreshCallable;
        private SdkPredicate<T> shouldDoBlockingRefresh;
        private SdkPredicate<T> shouldDoAsyncRefresh;

        public Builder withRefreshCallable(Callable<T> refreshCallable) {
            this.refreshCallable = refreshCallable;
            return this;
        }

        public Builder withBlockingRefreshPredicate(SdkPredicate<T> shouldDoBlockingRefresh) {
            this.shouldDoBlockingRefresh = shouldDoBlockingRefresh;
            return this;
        }

        public Builder withAsyncRefreshPredicate(SdkPredicate<T> shouldDoAsyncRefresh) {
            this.shouldDoAsyncRefresh = shouldDoAsyncRefresh;
            return this;
        }

        public RefreshableTask<T> build() {
            return new RefreshableTask(this.refreshCallable, this.shouldDoBlockingRefresh, this.shouldDoAsyncRefresh);
        }
    }
}

