/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.annotation.Immutable;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry.RetryMode;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry.internal.RetryModeResolver;

@Immutable
public final class RetryPolicy {
    private static final RetryModeResolver RETRY_MODE_RESOLVER = new RetryModeResolver();
    private final RetryCondition retryCondition;
    private final BackoffStrategy backoffStrategy;
    private final int maxErrorRetry;
    private final boolean honorMaxErrorRetryInClientConfig;
    private final RetryMode retryMode;
    private final boolean honorDefaultMaxErrorRetryInRetryMode;

    public RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int maxErrorRetry, boolean honorMaxErrorRetryInClientConfig) {
        this(retryCondition, backoffStrategy, maxErrorRetry, honorMaxErrorRetryInClientConfig, false);
    }

    @SdkInternalApi
    public RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int maxErrorRetry, boolean honorMaxErrorRetryInClientConfig, boolean honorDefaultMaxErrorRetryInRetryMode) {
        this(retryCondition, backoffStrategy, maxErrorRetry, honorMaxErrorRetryInClientConfig, null, honorDefaultMaxErrorRetryInRetryMode);
    }

    public RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int maxErrorRetry, boolean honorMaxErrorRetryInClientConfig, RetryMode retryMode) {
        this(retryCondition, backoffStrategy, maxErrorRetry, honorMaxErrorRetryInClientConfig, retryMode, false);
    }

    @SdkInternalApi
    RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int maxErrorRetry, boolean honorMaxErrorRetryInClientConfig, RetryMode retryMode, boolean honorDefaultMaxErrorRetryInRetryMode) {
        if (retryCondition == null) {
            retryCondition = PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION;
        }
        if (backoffStrategy == null) {
            backoffStrategy = PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY;
        }
        if (maxErrorRetry < 0) {
            throw new IllegalArgumentException("Please provide a non-negative value for maxErrorRetry.");
        }
        this.honorDefaultMaxErrorRetryInRetryMode = honorDefaultMaxErrorRetryInRetryMode;
        this.retryCondition = retryCondition;
        this.backoffStrategy = backoffStrategy;
        this.maxErrorRetry = maxErrorRetry;
        this.honorMaxErrorRetryInClientConfig = honorMaxErrorRetryInClientConfig;
        this.retryMode = retryMode != null ? retryMode : RETRY_MODE_RESOLVER.retryMode();
    }

    public RetryCondition getRetryCondition() {
        return this.retryCondition;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public boolean isMaxErrorRetryInClientConfigHonored() {
        return this.honorMaxErrorRetryInClientConfig;
    }

    public RetryMode getRetryMode() {
        return this.retryMode;
    }

    boolean isDefaultMaxErrorRetryInRetryModeHonored() {
        return this.honorDefaultMaxErrorRetryInRetryMode;
    }

    public static interface BackoffStrategy {
        public static final BackoffStrategy NO_DELAY = new BackoffStrategy(){

            @Override
            public long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
                return 0L;
            }
        };

        public long delayBeforeNextRetry(AmazonWebServiceRequest var1, AmazonClientException var2, int var3);
    }

    public static interface RetryCondition {
        public static final RetryCondition NO_RETRY_CONDITION = new RetryCondition(){

            @Override
            public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
                return false;
            }
        };

        public boolean shouldRetry(AmazonWebServiceRequest var1, AmazonClientException var2, int var3);
    }
}

