/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.ClientConfiguration;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry.RetryMode;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry.internal.MaxAttemptsResolver;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.retry.v2.RetryPolicy {
    private final RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;
    private final int maxErrorRetry;

    public RetryPolicyAdapter(RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
        this.maxErrorRetry = this.resolveMaxErrorRetry();
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return !this.maxRetriesExceeded(context) && this.isRetryable(context);
    }

    public boolean isRetryable(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int resolveMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        Integer resolvedMaxAttempts = new MaxAttemptsResolver().maxAttempts();
        if (resolvedMaxAttempts != null) {
            return resolvedMaxAttempts - 1;
        }
        if (this.shouldUseStandardModeDefaultMaxRetry()) {
            return 2;
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }

    private boolean shouldUseStandardModeDefaultMaxRetry() {
        RetryMode retryMode = this.clientConfiguration.getRetryMode() == null ? this.legacyRetryPolicy.getRetryMode() : this.clientConfiguration.getRetryMode();
        return retryMode.equals((Object)RetryMode.STANDARD) && this.legacyRetryPolicy.isDefaultMaxErrorRetryInRetryModeHonored();
    }

    public boolean maxRetriesExceeded(RetryPolicyContext context) {
        return context.retriesAttempted() >= this.maxErrorRetry;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }
}

