/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model.ContextKeyTypeEnum;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ContextEntry
implements Serializable,
Cloneable {
    private String contextKeyName;
    private SdkInternalList<String> contextKeyValues;
    private String contextKeyType;

    public void setContextKeyName(String contextKeyName) {
        this.contextKeyName = contextKeyName;
    }

    public String getContextKeyName() {
        return this.contextKeyName;
    }

    public ContextEntry withContextKeyName(String contextKeyName) {
        this.setContextKeyName(contextKeyName);
        return this;
    }

    public List<String> getContextKeyValues() {
        if (this.contextKeyValues == null) {
            this.contextKeyValues = new SdkInternalList();
        }
        return this.contextKeyValues;
    }

    public void setContextKeyValues(Collection<String> contextKeyValues) {
        if (contextKeyValues == null) {
            this.contextKeyValues = null;
            return;
        }
        this.contextKeyValues = new SdkInternalList<String>(contextKeyValues);
    }

    public ContextEntry withContextKeyValues(String ... contextKeyValues) {
        if (this.contextKeyValues == null) {
            this.setContextKeyValues(new SdkInternalList<String>(contextKeyValues.length));
        }
        for (String ele : contextKeyValues) {
            this.contextKeyValues.add(ele);
        }
        return this;
    }

    public ContextEntry withContextKeyValues(Collection<String> contextKeyValues) {
        this.setContextKeyValues(contextKeyValues);
        return this;
    }

    public void setContextKeyType(String contextKeyType) {
        this.contextKeyType = contextKeyType;
    }

    public String getContextKeyType() {
        return this.contextKeyType;
    }

    public ContextEntry withContextKeyType(String contextKeyType) {
        this.setContextKeyType(contextKeyType);
        return this;
    }

    public void setContextKeyType(ContextKeyTypeEnum contextKeyType) {
        this.withContextKeyType(contextKeyType);
    }

    public ContextEntry withContextKeyType(ContextKeyTypeEnum contextKeyType) {
        this.contextKeyType = contextKeyType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContextKeyName() != null) {
            sb.append("ContextKeyName: ").append(this.getContextKeyName()).append(",");
        }
        if (this.getContextKeyValues() != null) {
            sb.append("ContextKeyValues: ").append(this.getContextKeyValues()).append(",");
        }
        if (this.getContextKeyType() != null) {
            sb.append("ContextKeyType: ").append(this.getContextKeyType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextEntry)) {
            return false;
        }
        ContextEntry other = (ContextEntry)obj;
        if (other.getContextKeyName() == null ^ this.getContextKeyName() == null) {
            return false;
        }
        if (other.getContextKeyName() != null && !other.getContextKeyName().equals(this.getContextKeyName())) {
            return false;
        }
        if (other.getContextKeyValues() == null ^ this.getContextKeyValues() == null) {
            return false;
        }
        if (other.getContextKeyValues() != null && !other.getContextKeyValues().equals(this.getContextKeyValues())) {
            return false;
        }
        if (other.getContextKeyType() == null ^ this.getContextKeyType() == null) {
            return false;
        }
        return other.getContextKeyType() == null || other.getContextKeyType().equals(this.getContextKeyType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContextKeyName() == null ? 0 : this.getContextKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getContextKeyValues() == null ? 0 : this.getContextKeyValues().hashCode());
        hashCode = 31 * hashCode + (this.getContextKeyType() == null ? 0 : this.getContextKeyType().hashCode());
        return hashCode;
    }

    public ContextEntry clone() {
        try {
            return (ContextEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

