/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TagUserRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String userName;
    private SdkInternalList<Tag> tags;

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public TagUserRequest withUserName(String userName) {
        this.setUserName(userName);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public TagUserRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TagUserRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserName() != null) {
            sb.append("UserName: ").append(this.getUserName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagUserRequest)) {
            return false;
        }
        TagUserRequest other = (TagUserRequest)obj;
        if (other.getUserName() == null ^ this.getUserName() == null) {
            return false;
        }
        if (other.getUserName() != null && !other.getUserName().equals(this.getUserName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public TagUserRequest clone() {
        return (TagUserRequest)super.clone();
    }
}

