/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.Request;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model.Tag;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.util.StringUtils;

public class CreateRoleRequestMarshaller
implements Marshaller<Request<CreateRoleRequest>, CreateRoleRequest> {
    @Override
    public Request<CreateRoleRequest> marshall(CreateRoleRequest createRoleRequest) {
        if (createRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateRoleRequest> request = new DefaultRequest<CreateRoleRequest>(createRoleRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRoleRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString(createRoleRequest.getPath()));
        }
        if (createRoleRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(createRoleRequest.getRoleName()));
        }
        if (createRoleRequest.getAssumeRolePolicyDocument() != null) {
            request.addParameter("AssumeRolePolicyDocument", StringUtils.fromString(createRoleRequest.getAssumeRolePolicyDocument()));
        }
        if (createRoleRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createRoleRequest.getDescription()));
        }
        if (createRoleRequest.getMaxSessionDuration() != null) {
            request.addParameter("MaxSessionDuration", StringUtils.fromInteger(createRoleRequest.getMaxSessionDuration()));
        }
        if (createRoleRequest.getPermissionsBoundary() != null) {
            request.addParameter("PermissionsBoundary", StringUtils.fromString(createRoleRequest.getPermissionsBoundary()));
        }
        if (!createRoleRequest.getTags().isEmpty() || !((SdkInternalList)createRoleRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createRoleRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

