/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.identitymanagement.model.PolicyVersion;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PolicyVersionStaxUnmarshaller
implements Unmarshaller<PolicyVersion, StaxUnmarshallerContext> {
    private static PolicyVersionStaxUnmarshaller instance;

    @Override
    public PolicyVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        PolicyVersion policyVersion = new PolicyVersion();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return policyVersion;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Document", targetDepth)) {
                    policyVersion.setDocument(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    policyVersion.setVersionId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsDefaultVersion", targetDepth)) {
                    policyVersion.setIsDefaultVersion(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CreateDate", targetDepth)) continue;
                policyVersion.setCreateDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return policyVersion;
    }

    public static PolicyVersionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PolicyVersionStaxUnmarshaller();
        }
        return instance;
    }
}

