/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.kinesis.model.Consumer;
import java.util.Date;

@SdkInternalApi
public class ConsumerMarshaller {
    private static final MarshallingInfo<String> CONSUMERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerName").build();
    private static final MarshallingInfo<String> CONSUMERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerARN").build();
    private static final MarshallingInfo<String> CONSUMERSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerStatus").build();
    private static final MarshallingInfo<Date> CONSUMERCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerCreationTimestamp").timestampFormat("unixTimestampInMillis").build();
    private static final ConsumerMarshaller instance = new ConsumerMarshaller();

    public static ConsumerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Consumer consumer, ProtocolMarshaller protocolMarshaller) {
        if (consumer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(consumer.getConsumerName(), CONSUMERNAME_BINDING);
            protocolMarshaller.marshall(consumer.getConsumerARN(), CONSUMERARN_BINDING);
            protocolMarshaller.marshall(consumer.getConsumerStatus(), CONSUMERSTATUS_BINDING);
            protocolMarshaller.marshall(consumer.getConsumerCreationTimestamp(), CONSUMERCREATIONTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

