/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalytics.shaded.com.amazonaws.services.kinesisfirehose.model.Deserializer;

@SdkInternalApi
public class DeserializerMarshaller {
    private static final MarshallingInfo<StructuredPojo> OPENXJSONSERDE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OpenXJsonSerDe").build();
    private static final MarshallingInfo<StructuredPojo> HIVEJSONSERDE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HiveJsonSerDe").build();
    private static final DeserializerMarshaller instance = new DeserializerMarshaller();

    public static DeserializerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Deserializer deserializer, ProtocolMarshaller protocolMarshaller) {
        if (deserializer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(deserializer.getOpenXJsonSerDe(), OPENXJSONSERDE_BINDING);
            protocolMarshaller.marshall(deserializer.getHiveJsonSerDe(), HIVEJSONSERDE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

